# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.iteration_api_result import IterationApiResult
from testit_api_client.models.link_short_api_result import LinkShortApiResult
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from testit_api_client.models.work_item_states import WorkItemStates

class WorkItemShortApiResult(BaseModel):
    """
    WorkItemShortApiResult
    """
    id: StrictStr = Field(default=..., description="Work Item internal unique identifier")
    version_id: StrictStr = Field(default=..., alias="versionId", description="Work Item version identifier")
    version_number: StrictInt = Field(default=..., alias="versionNumber", description="Work Item version number")
    name: StrictStr = Field(default=..., description="Work Item name")
    entity_type_name: StrictStr = Field(default=..., alias="entityTypeName", description="Work Item type. Possible values: CheckLists, SharedSteps, TestCases")
    project_id: StrictStr = Field(default=..., alias="projectId", description="Project unique identifier")
    section_id: StrictStr = Field(default=..., alias="sectionId", description="Identifier of Section where Work Item is located")
    section_name: StrictStr = Field(default=..., alias="sectionName", description="Section name of Work Item")
    is_automated: StrictBool = Field(default=..., alias="isAutomated", description="Boolean flag determining whether Work Item is automated")
    global_id: StrictInt = Field(default=..., alias="globalId", description="Work Item global identifier")
    duration: StrictInt = Field(default=..., description="Work Item duration")
    median_duration: Optional[StrictInt] = Field(default=None, alias="medianDuration", description="Work Item median duration")
    attributes: Optional[Dict[str, Any]] = Field(default=None, description="Work Item attributes")
    created_by_id: StrictStr = Field(default=..., alias="createdById", description="Unique identifier of user who created Work Item")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById", description="Unique identifier of user who applied the latest modification of Work Item")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate", description="Date and time of Work Item creation")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate", description="Date and time of the latest modification of Work Item")
    state: WorkItemStates = Field(default=..., description="The current state of Work Item")
    priority: WorkItemPriorityModel = Field(default=..., description="Work Item priority level")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Flag determining whether Work Item is deleted")
    tag_names: Optional[conlist(StrictStr)] = Field(default=None, alias="tagNames", description="Array of tag names of Work Item")
    iterations: conlist(IterationApiResult) = Field(default=..., description="Set of iterations related to Work Item")
    links: conlist(LinkShortApiResult) = Field(default=..., description="Set of links related to Work Item")
    __properties = ["id", "versionId", "versionNumber", "name", "entityTypeName", "projectId", "sectionId", "sectionName", "isAutomated", "globalId", "duration", "medianDuration", "attributes", "createdById", "modifiedById", "createdDate", "modifiedDate", "state", "priority", "isDeleted", "tagNames", "iterations", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkItemShortApiResult:
        """Create an instance of WorkItemShortApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in iterations (list)
        _items = []
        if self.iterations:
            for _item in self.iterations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['iterations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if median_duration (nullable) is None
        # and __fields_set__ contains the field
        if self.median_duration is None and "median_duration" in self.__fields_set__:
            _dict['medianDuration'] = None

        # set to None if attributes (nullable) is None
        # and __fields_set__ contains the field
        if self.attributes is None and "attributes" in self.__fields_set__:
            _dict['attributes'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if tag_names (nullable) is None
        # and __fields_set__ contains the field
        if self.tag_names is None and "tag_names" in self.__fields_set__:
            _dict['tagNames'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkItemShortApiResult:
        """Create an instance of WorkItemShortApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkItemShortApiResult.parse_obj(obj)

        _obj = WorkItemShortApiResult.parse_obj({
            "id": obj.get("id"),
            "version_id": obj.get("versionId"),
            "version_number": obj.get("versionNumber"),
            "name": obj.get("name"),
            "entity_type_name": obj.get("entityTypeName"),
            "project_id": obj.get("projectId"),
            "section_id": obj.get("sectionId"),
            "section_name": obj.get("sectionName"),
            "is_automated": obj.get("isAutomated"),
            "global_id": obj.get("globalId"),
            "duration": obj.get("duration"),
            "median_duration": obj.get("medianDuration"),
            "attributes": obj.get("attributes"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "state": obj.get("state"),
            "priority": obj.get("priority"),
            "is_deleted": obj.get("isDeleted"),
            "tag_names": obj.get("tagNames"),
            "iterations": [IterationApiResult.from_dict(_item) for _item in obj.get("iterations")] if obj.get("iterations") is not None else None,
            "links": [LinkShortApiResult.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj


