# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, constr
from testit_api_client.models.attachment_put_model import AttachmentPutModel
from testit_api_client.models.auto_test_id_model import AutoTestIdModel
from testit_api_client.models.iteration_put_model import IterationPutModel
from testit_api_client.models.link_put_model import LinkPutModel
from testit_api_client.models.step_put_model import StepPutModel
from testit_api_client.models.tag_put_model import TagPutModel
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from testit_api_client.models.work_item_states import WorkItemStates

class WorkItemPutModel(BaseModel):
    """
    WorkItemPutModel
    """
    attachments: conlist(AttachmentPutModel) = Field(...)
    iterations: Optional[conlist(IterationPutModel)] = None
    auto_tests: Optional[conlist(AutoTestIdModel)] = Field(default=None, alias="autoTests")
    id: StrictStr = Field(...)
    section_id: StrictStr = Field(default=..., alias="sectionId")
    description: Optional[StrictStr] = None
    state: WorkItemStates = Field(...)
    priority: WorkItemPriorityModel = Field(...)
    steps: conlist(StepPutModel) = Field(...)
    precondition_steps: conlist(StepPutModel) = Field(default=..., alias="preconditionSteps")
    postcondition_steps: conlist(StepPutModel) = Field(default=..., alias="postconditionSteps")
    duration: conint(strict=True, le=86400000, ge=0) = Field(...)
    attributes: Dict[str, Any] = Field(...)
    tags: conlist(TagPutModel) = Field(...)
    links: conlist(LinkPutModel) = Field(...)
    name: constr(strict=True, min_length=1) = Field(...)
    __properties = ["attachments", "iterations", "autoTests", "id", "sectionId", "description", "state", "priority", "steps", "preconditionSteps", "postconditionSteps", "duration", "attributes", "tags", "links", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkItemPutModel:
        """Create an instance of WorkItemPutModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in iterations (list)
        _items = []
        if self.iterations:
            for _item in self.iterations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['iterations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in auto_tests (list)
        _items = []
        if self.auto_tests:
            for _item in self.auto_tests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['autoTests'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in precondition_steps (list)
        _items = []
        if self.precondition_steps:
            for _item in self.precondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['preconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in postcondition_steps (list)
        _items = []
        if self.postcondition_steps:
            for _item in self.postcondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['postconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if iterations (nullable) is None
        # and __fields_set__ contains the field
        if self.iterations is None and "iterations" in self.__fields_set__:
            _dict['iterations'] = None

        # set to None if auto_tests (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_tests is None and "auto_tests" in self.__fields_set__:
            _dict['autoTests'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkItemPutModel:
        """Create an instance of WorkItemPutModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkItemPutModel.parse_obj(obj)

        _obj = WorkItemPutModel.parse_obj({
            "attachments": [AttachmentPutModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "iterations": [IterationPutModel.from_dict(_item) for _item in obj.get("iterations")] if obj.get("iterations") is not None else None,
            "auto_tests": [AutoTestIdModel.from_dict(_item) for _item in obj.get("autoTests")] if obj.get("autoTests") is not None else None,
            "id": obj.get("id"),
            "section_id": obj.get("sectionId"),
            "description": obj.get("description"),
            "state": obj.get("state"),
            "priority": obj.get("priority"),
            "steps": [StepPutModel.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "precondition_steps": [StepPutModel.from_dict(_item) for _item in obj.get("preconditionSteps")] if obj.get("preconditionSteps") is not None else None,
            "postcondition_steps": [StepPutModel.from_dict(_item) for _item in obj.get("postconditionSteps")] if obj.get("postconditionSteps") is not None else None,
            "duration": obj.get("duration"),
            "attributes": obj.get("attributes"),
            "tags": [TagPutModel.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None,
            "links": [LinkPutModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "name": obj.get("name")
        })
        return _obj


