# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist, constr
from testit_api_client.models.attachment_model import AttachmentModel
from testit_api_client.models.auto_test_model import AutoTestModel
from testit_api_client.models.iteration_model import IterationModel
from testit_api_client.models.link_model import LinkModel
from testit_api_client.models.step_model import StepModel
from testit_api_client.models.tag_put_model import TagPutModel
from testit_api_client.models.work_item_entity_types import WorkItemEntityTypes
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from testit_api_client.models.work_item_states import WorkItemStates

class WorkItemModel(BaseModel):
    """
    WorkItemModel
    """
    version_id: StrictStr = Field(default=..., alias="versionId", description="used for versioning changes in workitem")
    median_duration: StrictInt = Field(default=..., alias="medianDuration", description="used for getting a median duration of all autotests related to this workitem")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    project_id: StrictStr = Field(default=..., alias="projectId")
    entity_type_name: WorkItemEntityTypes = Field(default=..., alias="entityTypeName")
    is_automated: StrictBool = Field(default=..., alias="isAutomated")
    auto_tests: Optional[conlist(AutoTestModel)] = Field(default=None, alias="autoTests")
    attachments: Optional[conlist(AttachmentModel)] = None
    section_precondition_steps: Optional[conlist(StepModel)] = Field(default=None, alias="sectionPreconditionSteps")
    section_postcondition_steps: Optional[conlist(StepModel)] = Field(default=None, alias="sectionPostconditionSteps")
    version_number: StrictInt = Field(default=..., alias="versionNumber", description="used for define chronology of workitem state in each version")
    iterations: Optional[conlist(IterationModel)] = None
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    global_id: StrictInt = Field(default=..., alias="globalId")
    id: StrictStr = Field(...)
    section_id: StrictStr = Field(default=..., alias="sectionId")
    description: Optional[StrictStr] = None
    state: WorkItemStates = Field(...)
    priority: WorkItemPriorityModel = Field(...)
    steps: conlist(StepModel) = Field(...)
    precondition_steps: conlist(StepModel) = Field(default=..., alias="preconditionSteps")
    postcondition_steps: conlist(StepModel) = Field(default=..., alias="postconditionSteps")
    duration: conint(strict=True, le=86400000, ge=0) = Field(...)
    attributes: Dict[str, Any] = Field(...)
    tags: conlist(TagPutModel) = Field(...)
    links: conlist(LinkModel) = Field(...)
    name: constr(strict=True, min_length=1) = Field(...)
    __properties = ["versionId", "medianDuration", "isDeleted", "projectId", "entityTypeName", "isAutomated", "autoTests", "attachments", "sectionPreconditionSteps", "sectionPostconditionSteps", "versionNumber", "iterations", "createdDate", "modifiedDate", "createdById", "modifiedById", "globalId", "id", "sectionId", "description", "state", "priority", "steps", "preconditionSteps", "postconditionSteps", "duration", "attributes", "tags", "links", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkItemModel:
        """Create an instance of WorkItemModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in auto_tests (list)
        _items = []
        if self.auto_tests:
            for _item in self.auto_tests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['autoTests'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in section_precondition_steps (list)
        _items = []
        if self.section_precondition_steps:
            for _item in self.section_precondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sectionPreconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in section_postcondition_steps (list)
        _items = []
        if self.section_postcondition_steps:
            for _item in self.section_postcondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sectionPostconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in iterations (list)
        _items = []
        if self.iterations:
            for _item in self.iterations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['iterations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in precondition_steps (list)
        _items = []
        if self.precondition_steps:
            for _item in self.precondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['preconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in postcondition_steps (list)
        _items = []
        if self.postcondition_steps:
            for _item in self.postcondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['postconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if auto_tests (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_tests is None and "auto_tests" in self.__fields_set__:
            _dict['autoTests'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if section_precondition_steps (nullable) is None
        # and __fields_set__ contains the field
        if self.section_precondition_steps is None and "section_precondition_steps" in self.__fields_set__:
            _dict['sectionPreconditionSteps'] = None

        # set to None if section_postcondition_steps (nullable) is None
        # and __fields_set__ contains the field
        if self.section_postcondition_steps is None and "section_postcondition_steps" in self.__fields_set__:
            _dict['sectionPostconditionSteps'] = None

        # set to None if iterations (nullable) is None
        # and __fields_set__ contains the field
        if self.iterations is None and "iterations" in self.__fields_set__:
            _dict['iterations'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkItemModel:
        """Create an instance of WorkItemModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkItemModel.parse_obj(obj)

        _obj = WorkItemModel.parse_obj({
            "version_id": obj.get("versionId"),
            "median_duration": obj.get("medianDuration"),
            "is_deleted": obj.get("isDeleted"),
            "project_id": obj.get("projectId"),
            "entity_type_name": obj.get("entityTypeName"),
            "is_automated": obj.get("isAutomated"),
            "auto_tests": [AutoTestModel.from_dict(_item) for _item in obj.get("autoTests")] if obj.get("autoTests") is not None else None,
            "attachments": [AttachmentModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "section_precondition_steps": [StepModel.from_dict(_item) for _item in obj.get("sectionPreconditionSteps")] if obj.get("sectionPreconditionSteps") is not None else None,
            "section_postcondition_steps": [StepModel.from_dict(_item) for _item in obj.get("sectionPostconditionSteps")] if obj.get("sectionPostconditionSteps") is not None else None,
            "version_number": obj.get("versionNumber"),
            "iterations": [IterationModel.from_dict(_item) for _item in obj.get("iterations")] if obj.get("iterations") is not None else None,
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "global_id": obj.get("globalId"),
            "id": obj.get("id"),
            "section_id": obj.get("sectionId"),
            "description": obj.get("description"),
            "state": obj.get("state"),
            "priority": obj.get("priority"),
            "steps": [StepModel.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "precondition_steps": [StepModel.from_dict(_item) for _item in obj.get("preconditionSteps")] if obj.get("preconditionSteps") is not None else None,
            "postcondition_steps": [StepModel.from_dict(_item) for _item in obj.get("postconditionSteps")] if obj.get("postconditionSteps") is not None else None,
            "duration": obj.get("duration"),
            "attributes": obj.get("attributes"),
            "tags": [TagPutModel.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None,
            "links": [LinkModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "name": obj.get("name")
        })
        return _obj


