# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.int32_range_selector_model import Int32RangeSelectorModel
from testit_api_client.models.int64_range_selector_model import Int64RangeSelectorModel
from testit_api_client.models.work_item_entity_types import WorkItemEntityTypes
from testit_api_client.models.work_item_link_filter_api_model import WorkItemLinkFilterApiModel
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from testit_api_client.models.work_item_states import WorkItemStates

class WorkItemFilterApiModel(BaseModel):
    """
    WorkItemFilterApiModel
    """
    name_or_id: Optional[StrictStr] = Field(default=None, alias="nameOrId", description="Name or identifier (UUID) of work item")
    include_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="includeIds", description="Collection of identifiers of work items which need to be included in result regardless of filtering")
    exclude_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="excludeIds", description="Collection of identifiers of work items which need to be excluded from result regardless of filtering")
    project_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="projectIds", description="Collection of project identifiers")
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Name of work item")
    ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, description="Specifies a work item unique IDs to search for")
    global_ids: Optional[conlist(StrictInt, unique_items=True)] = Field(default=None, alias="globalIds", description="Collection of global (integer) identifiers")
    attributes: Optional[Dict[str, conlist(StrictStr, unique_items=True)]] = Field(default=None, description="Custom attributes of work item")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted", description="Is result must consist of only actual/deleted work items")
    section_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="sectionIds", description="Collection of section identifiers")
    created_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="createdByIds", description="Collection of identifiers of users who created work item")
    modified_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="modifiedByIds", description="Collection of identifiers of users who applied last modification to work item")
    states: Optional[conlist(WorkItemStates, unique_items=True)] = Field(default=None, description="Collection of states of work item")
    priorities: Optional[conlist(WorkItemPriorityModel, unique_items=True)] = Field(default=None, description="Collection of priorities of work item")
    types: Optional[conlist(WorkItemEntityTypes, unique_items=True)] = Field(default=None, description="Collection of types of work item")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate", description="Specifies a work item range of creation date to search for")
    modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="modifiedDate", description="Specifies a work item range of last modification date to search for")
    duration: Optional[Int32RangeSelectorModel] = Field(default=None, description="Specifies a work item duration range to search for")
    median_duration: Optional[Int64RangeSelectorModel] = Field(default=None, alias="medianDuration", description="Specifies a work item median duration range to search for")
    is_automated: Optional[StrictBool] = Field(default=None, alias="isAutomated", description="Is result must consist of only manual/automated work items")
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, description="Collection of tags")
    auto_test_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="autoTestIds", description="Collection of identifiers of linked autotests")
    work_item_version_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="workItemVersionIds", description="Collection of identifiers work items versions.")
    links: Optional[WorkItemLinkFilterApiModel] = Field(default=None, description="Specifies a work item filter by its links")
    __properties = ["nameOrId", "includeIds", "excludeIds", "projectIds", "name", "ids", "globalIds", "attributes", "isDeleted", "sectionIds", "createdByIds", "modifiedByIds", "states", "priorities", "types", "createdDate", "modifiedDate", "duration", "medianDuration", "isAutomated", "tags", "autoTestIds", "workItemVersionIds", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkItemFilterApiModel:
        """Create an instance of WorkItemFilterApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modified_date
        if self.modified_date:
            _dict['modifiedDate'] = self.modified_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of duration
        if self.duration:
            _dict['duration'] = self.duration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of median_duration
        if self.median_duration:
            _dict['medianDuration'] = self.median_duration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['links'] = self.links.to_dict()
        # set to None if name_or_id (nullable) is None
        # and __fields_set__ contains the field
        if self.name_or_id is None and "name_or_id" in self.__fields_set__:
            _dict['nameOrId'] = None

        # set to None if include_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.include_ids is None and "include_ids" in self.__fields_set__:
            _dict['includeIds'] = None

        # set to None if exclude_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.exclude_ids is None and "exclude_ids" in self.__fields_set__:
            _dict['excludeIds'] = None

        # set to None if project_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.project_ids is None and "project_ids" in self.__fields_set__:
            _dict['projectIds'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if ids (nullable) is None
        # and __fields_set__ contains the field
        if self.ids is None and "ids" in self.__fields_set__:
            _dict['ids'] = None

        # set to None if global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.global_ids is None and "global_ids" in self.__fields_set__:
            _dict['globalIds'] = None

        # set to None if attributes (nullable) is None
        # and __fields_set__ contains the field
        if self.attributes is None and "attributes" in self.__fields_set__:
            _dict['attributes'] = None

        # set to None if is_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.is_deleted is None and "is_deleted" in self.__fields_set__:
            _dict['isDeleted'] = None

        # set to None if section_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.section_ids is None and "section_ids" in self.__fields_set__:
            _dict['sectionIds'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if modified_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_ids is None and "modified_by_ids" in self.__fields_set__:
            _dict['modifiedByIds'] = None

        # set to None if states (nullable) is None
        # and __fields_set__ contains the field
        if self.states is None and "states" in self.__fields_set__:
            _dict['states'] = None

        # set to None if priorities (nullable) is None
        # and __fields_set__ contains the field
        if self.priorities is None and "priorities" in self.__fields_set__:
            _dict['priorities'] = None

        # set to None if types (nullable) is None
        # and __fields_set__ contains the field
        if self.types is None and "types" in self.__fields_set__:
            _dict['types'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if median_duration (nullable) is None
        # and __fields_set__ contains the field
        if self.median_duration is None and "median_duration" in self.__fields_set__:
            _dict['medianDuration'] = None

        # set to None if is_automated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_automated is None and "is_automated" in self.__fields_set__:
            _dict['isAutomated'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        # set to None if auto_test_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_test_ids is None and "auto_test_ids" in self.__fields_set__:
            _dict['autoTestIds'] = None

        # set to None if work_item_version_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_version_ids is None and "work_item_version_ids" in self.__fields_set__:
            _dict['workItemVersionIds'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkItemFilterApiModel:
        """Create an instance of WorkItemFilterApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkItemFilterApiModel.parse_obj(obj)

        _obj = WorkItemFilterApiModel.parse_obj({
            "name_or_id": obj.get("nameOrId"),
            "include_ids": obj.get("includeIds"),
            "exclude_ids": obj.get("excludeIds"),
            "project_ids": obj.get("projectIds"),
            "name": obj.get("name"),
            "ids": obj.get("ids"),
            "global_ids": obj.get("globalIds"),
            "attributes": obj.get("attributes"),
            "is_deleted": obj.get("isDeleted"),
            "section_ids": obj.get("sectionIds"),
            "created_by_ids": obj.get("createdByIds"),
            "modified_by_ids": obj.get("modifiedByIds"),
            "states": obj.get("states"),
            "priorities": obj.get("priorities"),
            "types": obj.get("types"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "modified_date": DateTimeRangeSelectorModel.from_dict(obj.get("modifiedDate")) if obj.get("modifiedDate") is not None else None,
            "duration": Int32RangeSelectorModel.from_dict(obj.get("duration")) if obj.get("duration") is not None else None,
            "median_duration": Int64RangeSelectorModel.from_dict(obj.get("medianDuration")) if obj.get("medianDuration") is not None else None,
            "is_automated": obj.get("isAutomated"),
            "tags": obj.get("tags"),
            "auto_test_ids": obj.get("autoTestIds"),
            "work_item_version_ids": obj.get("workItemVersionIds"),
            "links": WorkItemLinkFilterApiModel.from_dict(obj.get("links")) if obj.get("links") is not None else None
        })
        return _obj


