# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from testit_api_client.models.work_item_changed_fields_view_model import WorkItemChangedFieldsViewModel

class WorkItemChangeModel(BaseModel):
    """
    WorkItemChangeModel
    """
    id: StrictStr = Field(...)
    work_item_id: StrictStr = Field(default=..., alias="workItemId")
    old_version_id: StrictStr = Field(default=..., alias="oldVersionId")
    new_version_id: StrictStr = Field(default=..., alias="newVersionId")
    work_item_changed_fields: WorkItemChangedFieldsViewModel = Field(default=..., alias="workItemChangedFields")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    __properties = ["id", "workItemId", "oldVersionId", "newVersionId", "workItemChangedFields", "createdById", "createdDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkItemChangeModel:
        """Create an instance of WorkItemChangeModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of work_item_changed_fields
        if self.work_item_changed_fields:
            _dict['workItemChangedFields'] = self.work_item_changed_fields.to_dict()
        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkItemChangeModel:
        """Create an instance of WorkItemChangeModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkItemChangeModel.parse_obj(obj)

        _obj = WorkItemChangeModel.parse_obj({
            "id": obj.get("id"),
            "work_item_id": obj.get("workItemId"),
            "old_version_id": obj.get("oldVersionId"),
            "new_version_id": obj.get("newVersionId"),
            "work_item_changed_fields": WorkItemChangedFieldsViewModel.from_dict(obj.get("workItemChangedFields")) if obj.get("workItemChangedFields") is not None else None,
            "created_by_id": obj.get("createdById"),
            "created_date": obj.get("createdDate")
        })
        return _obj


