# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from testit_api_client.models.request_type_api_model import RequestTypeApiModel
from testit_api_client.models.web_hook_event_type_request import WebHookEventTypeRequest

class WebhooksDeleteFilterApiModel(BaseModel):
    """
    WebhooksDeleteFilterApiModel
    """
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Specifies a webhook name to search for")
    event_types: Optional[conlist(WebHookEventTypeRequest, unique_items=True)] = Field(default=None, alias="eventTypes", description="Specifies a webhook event types to search for")
    methods: Optional[conlist(RequestTypeApiModel, unique_items=True)] = Field(default=None, description="Specifies a webhook methods to search for")
    project_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="projectIds", description="Specifies a webhook project IDs to search for")
    is_enabled: Optional[StrictBool] = Field(default=None, alias="isEnabled", description="Specifies a webhook deleted status to search for")
    __properties = ["name", "eventTypes", "methods", "projectIds", "isEnabled"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebhooksDeleteFilterApiModel:
        """Create an instance of WebhooksDeleteFilterApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if event_types (nullable) is None
        # and __fields_set__ contains the field
        if self.event_types is None and "event_types" in self.__fields_set__:
            _dict['eventTypes'] = None

        # set to None if methods (nullable) is None
        # and __fields_set__ contains the field
        if self.methods is None and "methods" in self.__fields_set__:
            _dict['methods'] = None

        # set to None if project_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.project_ids is None and "project_ids" in self.__fields_set__:
            _dict['projectIds'] = None

        # set to None if is_enabled (nullable) is None
        # and __fields_set__ contains the field
        if self.is_enabled is None and "is_enabled" in self.__fields_set__:
            _dict['isEnabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebhooksDeleteFilterApiModel:
        """Create an instance of WebhooksDeleteFilterApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WebhooksDeleteFilterApiModel.parse_obj(obj)

        _obj = WebhooksDeleteFilterApiModel.parse_obj({
            "name": obj.get("name"),
            "event_types": obj.get("eventTypes"),
            "methods": obj.get("methods"),
            "project_ids": obj.get("projectIds"),
            "is_enabled": obj.get("isEnabled")
        })
        return _obj


