# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from testit_api_client.models.request_type_model import RequestTypeModel
from testit_api_client.models.web_hook_event_type_model import WebHookEventTypeModel

class WebHookLogModel(BaseModel):
    """
    WebHookLogModel
    """
    web_hook_name: StrictStr = Field(default=..., alias="webHookName")
    event_type: WebHookEventTypeModel = Field(default=..., alias="eventType")
    web_hook_id: StrictStr = Field(default=..., alias="webHookId")
    request_body: Optional[StrictStr] = Field(default=None, alias="requestBody")
    request_meta: Optional[StrictStr] = Field(default=None, alias="requestMeta")
    response_status_code: StrictInt = Field(default=..., alias="responseStatusCode")
    response_body: Optional[StrictStr] = Field(default=None, alias="responseBody")
    response_meta: Optional[StrictStr] = Field(default=None, alias="responseMeta")
    project_id: StrictStr = Field(default=..., alias="projectId")
    url: StrictStr = Field(...)
    request_type: RequestTypeModel = Field(default=..., alias="requestType")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    id: StrictStr = Field(default=..., description="Unique ID of the entity")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Indicates if the entity is deleted")
    __properties = ["webHookName", "eventType", "webHookId", "requestBody", "requestMeta", "responseStatusCode", "responseBody", "responseMeta", "projectId", "url", "requestType", "createdDate", "modifiedDate", "createdById", "modifiedById", "id", "isDeleted"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebHookLogModel:
        """Create an instance of WebHookLogModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if request_body (nullable) is None
        # and __fields_set__ contains the field
        if self.request_body is None and "request_body" in self.__fields_set__:
            _dict['requestBody'] = None

        # set to None if request_meta (nullable) is None
        # and __fields_set__ contains the field
        if self.request_meta is None and "request_meta" in self.__fields_set__:
            _dict['requestMeta'] = None

        # set to None if response_body (nullable) is None
        # and __fields_set__ contains the field
        if self.response_body is None and "response_body" in self.__fields_set__:
            _dict['responseBody'] = None

        # set to None if response_meta (nullable) is None
        # and __fields_set__ contains the field
        if self.response_meta is None and "response_meta" in self.__fields_set__:
            _dict['responseMeta'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebHookLogModel:
        """Create an instance of WebHookLogModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WebHookLogModel.parse_obj(obj)

        _obj = WebHookLogModel.parse_obj({
            "web_hook_name": obj.get("webHookName"),
            "event_type": obj.get("eventType"),
            "web_hook_id": obj.get("webHookId"),
            "request_body": obj.get("requestBody"),
            "request_meta": obj.get("requestMeta"),
            "response_status_code": obj.get("responseStatusCode"),
            "response_body": obj.get("responseBody"),
            "response_meta": obj.get("responseMeta"),
            "project_id": obj.get("projectId"),
            "url": obj.get("url"),
            "request_type": obj.get("requestType"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "id": obj.get("id"),
            "is_deleted": obj.get("isDeleted")
        })
        return _obj


