# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from testit_api_client.models.user_rank_model import UserRankModel

class UserWithRankModel(BaseModel):
    """
    UserWithRankModel
    """
    id: StrictStr = Field(...)
    first_name: StrictStr = Field(default=..., alias="firstName")
    last_name: StrictStr = Field(default=..., alias="lastName")
    middle_name: StrictStr = Field(default=..., alias="middleName")
    user_name: StrictStr = Field(default=..., alias="userName")
    display_name: StrictStr = Field(default=..., alias="displayName")
    user_type: StrictStr = Field(default=..., alias="userType")
    avatar_url: StrictStr = Field(default=..., alias="avatarUrl")
    avatar_metadata: StrictStr = Field(default=..., alias="avatarMetadata")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    is_disabled: StrictBool = Field(default=..., alias="isDisabled")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    is_active_status_by_entity: StrictBool = Field(default=..., alias="isActiveStatusByEntity")
    user_rank: UserRankModel = Field(default=..., alias="userRank")
    __properties = ["id", "firstName", "lastName", "middleName", "userName", "displayName", "userType", "avatarUrl", "avatarMetadata", "isDeleted", "isDisabled", "providerId", "isActiveStatusByEntity", "userRank"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserWithRankModel:
        """Create an instance of UserWithRankModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user_rank
        if self.user_rank:
            _dict['userRank'] = self.user_rank.to_dict()
        # set to None if provider_id (nullable) is None
        # and __fields_set__ contains the field
        if self.provider_id is None and "provider_id" in self.__fields_set__:
            _dict['providerId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserWithRankModel:
        """Create an instance of UserWithRankModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UserWithRankModel.parse_obj(obj)

        _obj = UserWithRankModel.parse_obj({
            "id": obj.get("id"),
            "first_name": obj.get("firstName"),
            "last_name": obj.get("lastName"),
            "middle_name": obj.get("middleName"),
            "user_name": obj.get("userName"),
            "display_name": obj.get("displayName"),
            "user_type": obj.get("userType"),
            "avatar_url": obj.get("avatarUrl"),
            "avatar_metadata": obj.get("avatarMetadata"),
            "is_deleted": obj.get("isDeleted"),
            "is_disabled": obj.get("isDisabled"),
            "provider_id": obj.get("providerId"),
            "is_active_status_by_entity": obj.get("isActiveStatusByEntity"),
            "user_rank": UserRankModel.from_dict(obj.get("userRank")) if obj.get("userRank") is not None else None
        })
        return _obj


