# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from testit_api_client.models.tag_api_model import TagApiModel

class UpdateTestPlanApiModel(BaseModel):
    """
    UpdateTestPlanApiModel
    """
    id: StrictStr = Field(default=..., description="Test plan unique internal identifier")
    locked_by_id: Optional[StrictStr] = Field(default=None, alias="lockedById", description="User who locked test plan modification internal identifier")
    name: constr(strict=True, max_length=450, min_length=0) = Field(default=..., description="Test plan name")
    start_date: Optional[datetime] = Field(default=None, alias="startDate", description="Date and time of test plan start")
    end_date: Optional[datetime] = Field(default=None, alias="endDate", description="Date and time of test plan end")
    description: Optional[constr(strict=True, max_length=100000, min_length=0)] = Field(default=None, description="Test plan description")
    build: Optional[constr(strict=True, max_length=450, min_length=0)] = Field(default=None, description="Build of the application on which test plan is executed")
    project_id: StrictStr = Field(default=..., alias="projectId", description="Project unique identifier")
    product_name: Optional[constr(strict=True, max_length=450, min_length=0)] = Field(default=None, alias="productName", description="Name of the testing product")
    has_automatic_duration_timer: Optional[StrictBool] = Field(default=None, alias="hasAutomaticDurationTimer", description="Boolean flag defines if test plan has automatic duration timer")
    attributes: Optional[Dict[str, Any]] = Field(default=None, description="Key value pair of test plan custom attributes")
    tags: Optional[conlist(TagApiModel)] = Field(default=None, description="Test plan tag names collection")
    __properties = ["id", "lockedById", "name", "startDate", "endDate", "description", "build", "projectId", "productName", "hasAutomaticDurationTimer", "attributes", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateTestPlanApiModel:
        """Create an instance of UpdateTestPlanApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # set to None if locked_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.locked_by_id is None and "locked_by_id" in self.__fields_set__:
            _dict['lockedById'] = None

        # set to None if start_date (nullable) is None
        # and __fields_set__ contains the field
        if self.start_date is None and "start_date" in self.__fields_set__:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict['endDate'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if build (nullable) is None
        # and __fields_set__ contains the field
        if self.build is None and "build" in self.__fields_set__:
            _dict['build'] = None

        # set to None if product_name (nullable) is None
        # and __fields_set__ contains the field
        if self.product_name is None and "product_name" in self.__fields_set__:
            _dict['productName'] = None

        # set to None if has_automatic_duration_timer (nullable) is None
        # and __fields_set__ contains the field
        if self.has_automatic_duration_timer is None and "has_automatic_duration_timer" in self.__fields_set__:
            _dict['hasAutomaticDurationTimer'] = None

        # set to None if attributes (nullable) is None
        # and __fields_set__ contains the field
        if self.attributes is None and "attributes" in self.__fields_set__:
            _dict['attributes'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateTestPlanApiModel:
        """Create an instance of UpdateTestPlanApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateTestPlanApiModel.parse_obj(obj)

        _obj = UpdateTestPlanApiModel.parse_obj({
            "id": obj.get("id"),
            "locked_by_id": obj.get("lockedById"),
            "name": obj.get("name"),
            "start_date": obj.get("startDate"),
            "end_date": obj.get("endDate"),
            "description": obj.get("description"),
            "build": obj.get("build"),
            "project_id": obj.get("projectId"),
            "product_name": obj.get("productName"),
            "has_automatic_duration_timer": obj.get("hasAutomaticDurationTimer"),
            "attributes": obj.get("attributes"),
            "tags": [TagApiModel.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


