# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr

class UpdateProjectApiModel(BaseModel):
    """
    UpdateProjectApiModel
    """
    id: StrictStr = Field(default=..., description="Unique ID of the project")
    name: constr(strict=True, min_length=1) = Field(default=..., description="Name of the project")
    description: Optional[StrictStr] = Field(default=None, description="Description of the project")
    is_favorite: Optional[StrictBool] = Field(default=None, alias="isFavorite", description="Indicates if the project is marked as favorite")
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId", description="Identifier of the workflow project should use")
    __properties = ["id", "name", "description", "isFavorite", "workflowId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateProjectApiModel:
        """Create an instance of UpdateProjectApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if is_favorite (nullable) is None
        # and __fields_set__ contains the field
        if self.is_favorite is None and "is_favorite" in self.__fields_set__:
            _dict['isFavorite'] = None

        # set to None if workflow_id (nullable) is None
        # and __fields_set__ contains the field
        if self.workflow_id is None and "workflow_id" in self.__fields_set__:
            _dict['workflowId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateProjectApiModel:
        """Create an instance of UpdateProjectApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateProjectApiModel.parse_obj(obj)

        _obj = UpdateProjectApiModel.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "is_favorite": obj.get("isFavorite"),
            "workflow_id": obj.get("workflowId")
        })
        return _obj


