# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr
from testit_api_client.models.test_suite_type import TestSuiteType

class TestSuiteV2PostModel(BaseModel):
    """
    TestSuiteV2PostModel
    """
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId", description="Unique ID of the parent test suite in hierarchy")
    test_plan_id: StrictStr = Field(default=..., alias="testPlanId", description="Unique ID of test plan to which the test suite belongs")
    name: constr(strict=True, max_length=255, min_length=0) = Field(default=..., description="Name of the test suite")
    type: Optional[TestSuiteType] = Field(default=None, description="Type of the test suite")
    save_structure: Optional[StrictBool] = Field(default=None, alias="saveStructure", description="Indicates if the test suite retains section tree structure")
    auto_refresh: Optional[StrictBool] = Field(default=None, alias="autoRefresh", description="Indicates if scheduled auto refresh is enabled for the test suite")
    __properties = ["parentId", "testPlanId", "name", "type", "saveStructure", "autoRefresh"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestSuiteV2PostModel:
        """Create an instance of TestSuiteV2PostModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if parent_id (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_id is None and "parent_id" in self.__fields_set__:
            _dict['parentId'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if save_structure (nullable) is None
        # and __fields_set__ contains the field
        if self.save_structure is None and "save_structure" in self.__fields_set__:
            _dict['saveStructure'] = None

        # set to None if auto_refresh (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_refresh is None and "auto_refresh" in self.__fields_set__:
            _dict['autoRefresh'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestSuiteV2PostModel:
        """Create an instance of TestSuiteV2PostModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestSuiteV2PostModel.parse_obj(obj)

        _obj = TestSuiteV2PostModel.parse_obj({
            "parent_id": obj.get("parentId"),
            "test_plan_id": obj.get("testPlanId"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "save_structure": obj.get("saveStructure"),
            "auto_refresh": obj.get("autoRefresh")
        })
        return _obj


