# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from testit_api_client.models.test_suite_type import TestSuiteType
from testit_api_client.models.work_item_select_model import WorkItemSelectModel

class TestSuiteTestPlanApiModel(BaseModel):
    """
    TestSuiteTestPlanApiModel
    """
    name: constr(strict=True, max_length=255, min_length=0) = Field(default=..., description="Test suite nane")
    configuration_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="configurationIds", description="Configuration identifiers. Empty configurations means using default configurations")
    type: Optional[TestSuiteType] = Field(default=None, description="Type of the test suite")
    save_structure: Optional[StrictBool] = Field(default=None, alias="saveStructure", description="Indicates if the test suite retains section tree structure")
    work_items_selector: WorkItemSelectModel = Field(default=..., alias="workItemsSelector", description="Model containing options to filter work items")
    __properties = ["name", "configurationIds", "type", "saveStructure", "workItemsSelector"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestSuiteTestPlanApiModel:
        """Create an instance of TestSuiteTestPlanApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of work_items_selector
        if self.work_items_selector:
            _dict['workItemsSelector'] = self.work_items_selector.to_dict()
        # set to None if configuration_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_ids is None and "configuration_ids" in self.__fields_set__:
            _dict['configurationIds'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if save_structure (nullable) is None
        # and __fields_set__ contains the field
        if self.save_structure is None and "save_structure" in self.__fields_set__:
            _dict['saveStructure'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestSuiteTestPlanApiModel:
        """Create an instance of TestSuiteTestPlanApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestSuiteTestPlanApiModel.parse_obj(obj)

        _obj = TestSuiteTestPlanApiModel.parse_obj({
            "name": obj.get("name"),
            "configuration_ids": obj.get("configurationIds"),
            "type": obj.get("type"),
            "save_structure": obj.get("saveStructure"),
            "work_items_selector": WorkItemSelectModel.from_dict(obj.get("workItemsSelector")) if obj.get("workItemsSelector") is not None else None
        })
        return _obj


