# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from testit_api_client.models.attachment_api_result import AttachmentApiResult
from testit_api_client.models.link_api_result import LinkApiResult
from testit_api_client.models.named_entity_api_model import NamedEntityApiModel
from testit_api_client.models.test_result_v2_get_model import TestResultV2GetModel
from testit_api_client.models.test_run_state import TestRunState
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestRunV2ApiResult(BaseModel):
    """
    TestRunV2ApiResult
    """
    id: StrictStr = Field(default=..., description="Test run unique identifier")
    name: StrictStr = Field(default=..., description="Test run name")
    description: Optional[StrictStr] = Field(default=None, description="Test run description")
    launch_source: Optional[StrictStr] = Field(default=None, alias="launchSource", description="Test run launch source                Once launch source is specified it cannot be updated.")
    started_on: Optional[datetime] = Field(default=None, alias="startedOn", description="Date and time of test run start")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn", description="Date and time of test run end")
    state_name: TestRunState = Field(default=..., alias="stateName", description="Test run state")
    status: TestStatusApiResult = Field(default=..., description="Test run status")
    project_id: StrictStr = Field(default=..., alias="projectId", description="Project unique identifier                This property is used to link test run with project.")
    test_plan_id: Optional[StrictStr] = Field(default=None, alias="testPlanId", description="Test plan unique identifier                This property is used to link test run with test plan.")
    test_results: Optional[conlist(TestResultV2GetModel)] = Field(default=None, alias="testResults", description="Enumeration of test results related to test run")
    created_date: datetime = Field(default=..., alias="createdDate", description="Date and time of test run creation")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate", description="Date and time of last test run  modification")
    created_by_id: StrictStr = Field(default=..., alias="createdById", description="Unique identifier of user who created test run")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById", description="Unique identifier of user who applied last test run  modification")
    created_by_user_name: Optional[StrictStr] = Field(default=None, alias="createdByUserName", description="Username of user who created test run")
    attachments: conlist(AttachmentApiResult) = Field(default=..., description="Collection of attachments related to the test run")
    links: conlist(LinkApiResult) = Field(default=..., description="Collection of links related to the test run")
    custom_parameters: Optional[Dict[str, StrictStr]] = Field(default=None, alias="customParameters", description="Customers test run parameters")
    webhooks: conlist(NamedEntityApiModel) = Field(default=..., description="Enabled webhooks")
    run_count: StrictInt = Field(default=..., alias="runCount", description="Run count")
    __properties = ["id", "name", "description", "launchSource", "startedOn", "completedOn", "stateName", "status", "projectId", "testPlanId", "testResults", "createdDate", "modifiedDate", "createdById", "modifiedById", "createdByUserName", "attachments", "links", "customParameters", "webhooks", "runCount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestRunV2ApiResult:
        """Create an instance of TestRunV2ApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in test_results (list)
        _items = []
        if self.test_results:
            for _item in self.test_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['testResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in webhooks (list)
        _items = []
        if self.webhooks:
            for _item in self.webhooks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['webhooks'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if launch_source (nullable) is None
        # and __fields_set__ contains the field
        if self.launch_source is None and "launch_source" in self.__fields_set__:
            _dict['launchSource'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if test_plan_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_id is None and "test_plan_id" in self.__fields_set__:
            _dict['testPlanId'] = None

        # set to None if test_results (nullable) is None
        # and __fields_set__ contains the field
        if self.test_results is None and "test_results" in self.__fields_set__:
            _dict['testResults'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if created_by_user_name (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_user_name is None and "created_by_user_name" in self.__fields_set__:
            _dict['createdByUserName'] = None

        # set to None if custom_parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.custom_parameters is None and "custom_parameters" in self.__fields_set__:
            _dict['customParameters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestRunV2ApiResult:
        """Create an instance of TestRunV2ApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestRunV2ApiResult.parse_obj(obj)

        _obj = TestRunV2ApiResult.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "launch_source": obj.get("launchSource"),
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "state_name": obj.get("stateName"),
            "status": TestStatusApiResult.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "project_id": obj.get("projectId"),
            "test_plan_id": obj.get("testPlanId"),
            "test_results": [TestResultV2GetModel.from_dict(_item) for _item in obj.get("testResults")] if obj.get("testResults") is not None else None,
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "created_by_user_name": obj.get("createdByUserName"),
            "attachments": [AttachmentApiResult.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "links": [LinkApiResult.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "custom_parameters": obj.get("customParameters"),
            "webhooks": [NamedEntityApiModel.from_dict(_item) for _item in obj.get("webhooks")] if obj.get("webhooks") is not None else None,
            "run_count": obj.get("runCount")
        })
        return _obj


