# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.link_post_model import LinkPostModel
from testit_api_client.models.test_run_test_results_select_model import TestRunTestResultsSelectModel

class TestRunTestResultsPartialBulkSetModel(BaseModel):
    """
    TestRunTestResultsPartialBulkSetModel
    """
    selector: Optional[TestRunTestResultsSelectModel] = Field(default=None, description="Object with filters and extraction parameters")
    result_reason_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="resultReasonIds", description="Unique IDs of result reasons to be assigned to test results")
    links: Optional[conlist(LinkPostModel, unique_items=True)] = Field(default=None, description="Collection of links to be assigned to test results")
    comment: Optional[StrictStr] = Field(default=None, description="Comment to be added to test results")
    attachment_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="attachmentIds", description="Unique IDs of files to be attached to test results")
    __properties = ["selector", "resultReasonIds", "links", "comment", "attachmentIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestRunTestResultsPartialBulkSetModel:
        """Create an instance of TestRunTestResultsPartialBulkSetModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of selector
        if self.selector:
            _dict['selector'] = self.selector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if selector (nullable) is None
        # and __fields_set__ contains the field
        if self.selector is None and "selector" in self.__fields_set__:
            _dict['selector'] = None

        # set to None if result_reason_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.result_reason_ids is None and "result_reason_ids" in self.__fields_set__:
            _dict['resultReasonIds'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        # set to None if attachment_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.attachment_ids is None and "attachment_ids" in self.__fields_set__:
            _dict['attachmentIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestRunTestResultsPartialBulkSetModel:
        """Create an instance of TestRunTestResultsPartialBulkSetModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestRunTestResultsPartialBulkSetModel.parse_obj(obj)

        _obj = TestRunTestResultsPartialBulkSetModel.parse_obj({
            "selector": TestRunTestResultsSelectModel.from_dict(obj.get("selector")) if obj.get("selector") is not None else None,
            "result_reason_ids": obj.get("resultReasonIds"),
            "links": [LinkPostModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "comment": obj.get("comment"),
            "attachment_ids": obj.get("attachmentIds")
        })
        return _obj


