# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.configuration_short_api_result import ConfigurationShortApiResult
from testit_api_client.models.test_results_statistics_api_result import TestResultsStatisticsApiResult
from testit_api_client.models.test_run_state import TestRunState
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestRunShortApiResult(BaseModel):
    """
    TestRunShortApiResult
    """
    id: StrictStr = Field(default=..., description="Unique ID of the test run")
    name: StrictStr = Field(default=..., description="Name of the test run")
    state: TestRunState = Field(default=..., description="Current state of the test run")
    status: TestStatusApiResult = Field(default=..., description="Current status of the test run")
    created_date: datetime = Field(default=..., alias="createdDate", description="Date when the test run was created")
    started_date: Optional[datetime] = Field(default=None, alias="startedDate", description="Date when the test run was started")
    completed_date: Optional[datetime] = Field(default=None, alias="completedDate", description="Completion date of the test run")
    created_by_id: StrictStr = Field(default=..., alias="createdById", description="Unique ID of user who created the test run")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById", description="Unique ID of user who modified the test run last time")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Is the test run is deleted")
    auto_tests_count: StrictInt = Field(default=..., alias="autoTestsCount", description="Number of AutoTests run in the test run")
    statistics: TestResultsStatisticsApiResult = Field(default=..., description="Statistics of the test run")
    test_results_configurations: conlist(ConfigurationShortApiResult) = Field(default=..., alias="testResultsConfigurations", description="Test results configurations")
    __properties = ["id", "name", "state", "status", "createdDate", "startedDate", "completedDate", "createdById", "modifiedById", "isDeleted", "autoTestsCount", "statistics", "testResultsConfigurations"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestRunShortApiResult:
        """Create an instance of TestRunShortApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in test_results_configurations (list)
        _items = []
        if self.test_results_configurations:
            for _item in self.test_results_configurations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['testResultsConfigurations'] = _items
        # set to None if started_date (nullable) is None
        # and __fields_set__ contains the field
        if self.started_date is None and "started_date" in self.__fields_set__:
            _dict['startedDate'] = None

        # set to None if completed_date (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_date is None and "completed_date" in self.__fields_set__:
            _dict['completedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestRunShortApiResult:
        """Create an instance of TestRunShortApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestRunShortApiResult.parse_obj(obj)

        _obj = TestRunShortApiResult.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "state": obj.get("state"),
            "status": TestStatusApiResult.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "created_date": obj.get("createdDate"),
            "started_date": obj.get("startedDate"),
            "completed_date": obj.get("completedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "is_deleted": obj.get("isDeleted"),
            "auto_tests_count": obj.get("autoTestsCount"),
            "statistics": TestResultsStatisticsApiResult.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None,
            "test_results_configurations": [ConfigurationShortApiResult.from_dict(_item) for _item in obj.get("testResultsConfigurations")] if obj.get("testResultsConfigurations") is not None else None
        })
        return _obj


