# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from testit_api_client.models.failure_category_model import FailureCategoryModel
from testit_api_client.models.test_result_outcome import TestResultOutcome

class TestResultsLocalFilterModel(BaseModel):
    """
    TestResultsLocalFilterModel
    """
    configuration_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="configurationIds", description="Specifies a test result configuration IDs to search for")
    outcomes: Optional[conlist(TestResultOutcome)] = Field(default=None, description="Specifies a test result outcomes to search for")
    status_codes: Optional[conlist(StrictStr)] = Field(default=None, alias="statusCodes", description="Specifies a test result status codes to search for")
    failure_categories: Optional[conlist(FailureCategoryModel)] = Field(default=None, alias="failureCategories", description="Specifies a test result failure categories to search for")
    namespace: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Specifies a test result namespace to search for")
    class_name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, alias="className", description="Specifies a test result class name to search for")
    __properties = ["configurationIds", "outcomes", "statusCodes", "failureCategories", "namespace", "className"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultsLocalFilterModel:
        """Create an instance of TestResultsLocalFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if configuration_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_ids is None and "configuration_ids" in self.__fields_set__:
            _dict['configurationIds'] = None

        # set to None if outcomes (nullable) is None
        # and __fields_set__ contains the field
        if self.outcomes is None and "outcomes" in self.__fields_set__:
            _dict['outcomes'] = None

        # set to None if status_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.status_codes is None and "status_codes" in self.__fields_set__:
            _dict['statusCodes'] = None

        # set to None if failure_categories (nullable) is None
        # and __fields_set__ contains the field
        if self.failure_categories is None and "failure_categories" in self.__fields_set__:
            _dict['failureCategories'] = None

        # set to None if namespace (nullable) is None
        # and __fields_set__ contains the field
        if self.namespace is None and "namespace" in self.__fields_set__:
            _dict['namespace'] = None

        # set to None if class_name (nullable) is None
        # and __fields_set__ contains the field
        if self.class_name is None and "class_name" in self.__fields_set__:
            _dict['className'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultsLocalFilterModel:
        """Create an instance of TestResultsLocalFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultsLocalFilterModel.parse_obj(obj)

        _obj = TestResultsLocalFilterModel.parse_obj({
            "configuration_ids": obj.get("configurationIds"),
            "outcomes": obj.get("outcomes"),
            "status_codes": obj.get("statusCodes"),
            "failure_categories": obj.get("failureCategories"),
            "namespace": obj.get("namespace"),
            "class_name": obj.get("className")
        })
        return _obj


