# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist, constr
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.failure_category_model import FailureCategoryModel
from testit_api_client.models.int64_range_selector_model import Int64RangeSelectorModel
from testit_api_client.models.test_result_outcome import TestResultOutcome

class TestResultsFilterApiModel(BaseModel):
    """
    TestResultsFilterApiModel
    """
    configuration_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="configurationIds", description="Specifies a test result configuration IDs to search for")
    outcomes: Optional[conlist(TestResultOutcome)] = Field(default=None, description="Specifies a test result outcomes to search for")
    status_codes: Optional[conlist(StrictStr)] = Field(default=None, alias="statusCodes", description="Specifies a test result status codes to search for")
    failure_categories: Optional[conlist(FailureCategoryModel)] = Field(default=None, alias="failureCategories", description="Specifies a test result failure categories to search for")
    namespace: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Specifies a test result namespace to search for")
    class_name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, alias="className", description="Specifies a test result class name to search for")
    auto_test_global_ids: Optional[conlist(StrictInt)] = Field(default=None, alias="autoTestGlobalIds", description="Specifies an autotest global IDs to search results for")
    name: Optional[StrictStr] = Field(default=None, description="Specifies an autotest name to search results for")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate", description="Specifies a test result creation date and time range to search for")
    modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="modifiedDate", description="Specifies a test result modified date and time range to search for")
    started_on: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="startedOn", description="Specifies a test result started on date and time range to search for")
    completed_on: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="completedOn", description="Specifies a test result completed on date and time range to search for")
    duration: Optional[Int64RangeSelectorModel] = Field(default=None, description="Specifies a test result duration range to search for")
    result_reasons: Optional[conlist(StrictStr)] = Field(default=None, alias="resultReasons", description="Specifies result reasons for searching test results")
    test_run_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="testRunIds", description="Specifies a test result test run IDs to search for")
    __properties = ["configurationIds", "outcomes", "statusCodes", "failureCategories", "namespace", "className", "autoTestGlobalIds", "name", "createdDate", "modifiedDate", "startedOn", "completedOn", "duration", "resultReasons", "testRunIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultsFilterApiModel:
        """Create an instance of TestResultsFilterApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modified_date
        if self.modified_date:
            _dict['modifiedDate'] = self.modified_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of started_on
        if self.started_on:
            _dict['startedOn'] = self.started_on.to_dict()
        # override the default output from pydantic by calling `to_dict()` of completed_on
        if self.completed_on:
            _dict['completedOn'] = self.completed_on.to_dict()
        # override the default output from pydantic by calling `to_dict()` of duration
        if self.duration:
            _dict['duration'] = self.duration.to_dict()
        # set to None if configuration_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_ids is None and "configuration_ids" in self.__fields_set__:
            _dict['configurationIds'] = None

        # set to None if outcomes (nullable) is None
        # and __fields_set__ contains the field
        if self.outcomes is None and "outcomes" in self.__fields_set__:
            _dict['outcomes'] = None

        # set to None if status_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.status_codes is None and "status_codes" in self.__fields_set__:
            _dict['statusCodes'] = None

        # set to None if failure_categories (nullable) is None
        # and __fields_set__ contains the field
        if self.failure_categories is None and "failure_categories" in self.__fields_set__:
            _dict['failureCategories'] = None

        # set to None if namespace (nullable) is None
        # and __fields_set__ contains the field
        if self.namespace is None and "namespace" in self.__fields_set__:
            _dict['namespace'] = None

        # set to None if class_name (nullable) is None
        # and __fields_set__ contains the field
        if self.class_name is None and "class_name" in self.__fields_set__:
            _dict['className'] = None

        # set to None if auto_test_global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_test_global_ids is None and "auto_test_global_ids" in self.__fields_set__:
            _dict['autoTestGlobalIds'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if result_reasons (nullable) is None
        # and __fields_set__ contains the field
        if self.result_reasons is None and "result_reasons" in self.__fields_set__:
            _dict['resultReasons'] = None

        # set to None if test_run_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.test_run_ids is None and "test_run_ids" in self.__fields_set__:
            _dict['testRunIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultsFilterApiModel:
        """Create an instance of TestResultsFilterApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultsFilterApiModel.parse_obj(obj)

        _obj = TestResultsFilterApiModel.parse_obj({
            "configuration_ids": obj.get("configurationIds"),
            "outcomes": obj.get("outcomes"),
            "status_codes": obj.get("statusCodes"),
            "failure_categories": obj.get("failureCategories"),
            "namespace": obj.get("namespace"),
            "class_name": obj.get("className"),
            "auto_test_global_ids": obj.get("autoTestGlobalIds"),
            "name": obj.get("name"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "modified_date": DateTimeRangeSelectorModel.from_dict(obj.get("modifiedDate")) if obj.get("modifiedDate") is not None else None,
            "started_on": DateTimeRangeSelectorModel.from_dict(obj.get("startedOn")) if obj.get("startedOn") is not None else None,
            "completed_on": DateTimeRangeSelectorModel.from_dict(obj.get("completedOn")) if obj.get("completedOn") is not None else None,
            "duration": Int64RangeSelectorModel.from_dict(obj.get("duration")) if obj.get("duration") is not None else None,
            "result_reasons": obj.get("resultReasons"),
            "test_run_ids": obj.get("testRunIds")
        })
        return _obj


