# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.attachment_model import AttachmentModel
from testit_api_client.models.link_model import LinkModel
from testit_api_client.models.test_point_short_model import TestPointShortModel

class TestResultV2ShortModel(BaseModel):
    """
    TestResultV2ShortModel
    """
    id: StrictStr = Field(...)
    configuration_id: StrictStr = Field(default=..., alias="configurationId")
    work_item_version_id: StrictStr = Field(default=..., alias="workItemVersionId")
    auto_test_id: Optional[StrictStr] = Field(default=None, alias="autoTestId")
    message: Optional[StrictStr] = None
    traces: Optional[StrictStr] = None
    started_on: Optional[datetime] = Field(default=None, alias="startedOn")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn")
    run_by_user_id: Optional[StrictStr] = Field(default=None, alias="runByUserId")
    stopped_by_user_id: Optional[StrictStr] = Field(default=None, alias="stoppedByUserId")
    test_point_id: Optional[StrictStr] = Field(default=None, alias="testPointId")
    test_point: Optional[TestPointShortModel] = Field(default=None, alias="testPoint")
    test_run_id: StrictStr = Field(default=..., alias="testRunId")
    outcome: StrictStr = Field(default=..., description="Property can contain one of these values: Passed, Failed, InProgress, Blocked, Skipped")
    comment: Optional[StrictStr] = None
    links: Optional[conlist(LinkModel)] = None
    attachments: Optional[conlist(AttachmentModel)] = None
    parameters: Optional[Dict[str, StrictStr]] = None
    properties: Optional[Dict[str, StrictStr]] = None
    __properties = ["id", "configurationId", "workItemVersionId", "autoTestId", "message", "traces", "startedOn", "completedOn", "runByUserId", "stoppedByUserId", "testPointId", "testPoint", "testRunId", "outcome", "comment", "links", "attachments", "parameters", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultV2ShortModel:
        """Create an instance of TestResultV2ShortModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of test_point
        if self.test_point:
            _dict['testPoint'] = self.test_point.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if auto_test_id (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_test_id is None and "auto_test_id" in self.__fields_set__:
            _dict['autoTestId'] = None

        # set to None if message (nullable) is None
        # and __fields_set__ contains the field
        if self.message is None and "message" in self.__fields_set__:
            _dict['message'] = None

        # set to None if traces (nullable) is None
        # and __fields_set__ contains the field
        if self.traces is None and "traces" in self.__fields_set__:
            _dict['traces'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if run_by_user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.run_by_user_id is None and "run_by_user_id" in self.__fields_set__:
            _dict['runByUserId'] = None

        # set to None if stopped_by_user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.stopped_by_user_id is None and "stopped_by_user_id" in self.__fields_set__:
            _dict['stoppedByUserId'] = None

        # set to None if test_point_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_point_id is None and "test_point_id" in self.__fields_set__:
            _dict['testPointId'] = None

        # set to None if test_point (nullable) is None
        # and __fields_set__ contains the field
        if self.test_point is None and "test_point" in self.__fields_set__:
            _dict['testPoint'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.parameters is None and "parameters" in self.__fields_set__:
            _dict['parameters'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultV2ShortModel:
        """Create an instance of TestResultV2ShortModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultV2ShortModel.parse_obj(obj)

        _obj = TestResultV2ShortModel.parse_obj({
            "id": obj.get("id"),
            "configuration_id": obj.get("configurationId"),
            "work_item_version_id": obj.get("workItemVersionId"),
            "auto_test_id": obj.get("autoTestId"),
            "message": obj.get("message"),
            "traces": obj.get("traces"),
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "run_by_user_id": obj.get("runByUserId"),
            "stopped_by_user_id": obj.get("stoppedByUserId"),
            "test_point_id": obj.get("testPointId"),
            "test_point": TestPointShortModel.from_dict(obj.get("testPoint")) if obj.get("testPoint") is not None else None,
            "test_run_id": obj.get("testRunId"),
            "outcome": obj.get("outcome"),
            "comment": obj.get("comment"),
            "links": [LinkModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "attachments": [AttachmentModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "parameters": obj.get("parameters"),
            "properties": obj.get("properties")
        })
        return _obj


