# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist
from testit_api_client.models.attachment_update_request import AttachmentUpdateRequest
from testit_api_client.models.auto_test_step_result_update_request import AutoTestStepResultUpdateRequest
from testit_api_client.models.link import Link
from testit_api_client.models.step_result_api_model import StepResultApiModel
from testit_api_client.models.test_result_outcome import TestResultOutcome
from testit_api_client.models.test_result_step_comment_update_request import TestResultStepCommentUpdateRequest

class TestResultUpdateV2Request(BaseModel):
    """
    TestResultUpdateV2Request
    """
    failure_class_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="failureClassIds")
    outcome: Optional[TestResultOutcome] = None
    status_code: Optional[StrictStr] = Field(default=None, alias="statusCode")
    comment: Optional[StrictStr] = None
    links: Optional[conlist(Link)] = None
    step_results: Optional[conlist(StepResultApiModel)] = Field(default=None, alias="stepResults")
    attachments: Optional[conlist(AttachmentUpdateRequest)] = None
    duration_in_ms: Optional[conint(strict=True, ge=0)] = Field(default=None, alias="durationInMs")
    duration: Optional[conint(strict=True, ge=0)] = None
    step_comments: Optional[conlist(TestResultStepCommentUpdateRequest)] = Field(default=None, alias="stepComments")
    setup_results: Optional[conlist(AutoTestStepResultUpdateRequest)] = Field(default=None, alias="setupResults")
    teardown_results: Optional[conlist(AutoTestStepResultUpdateRequest)] = Field(default=None, alias="teardownResults")
    message: Optional[StrictStr] = None
    trace: Optional[StrictStr] = None
    __properties = ["failureClassIds", "outcome", "statusCode", "comment", "links", "stepResults", "attachments", "durationInMs", "duration", "stepComments", "setupResults", "teardownResults", "message", "trace"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultUpdateV2Request:
        """Create an instance of TestResultUpdateV2Request from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in step_results (list)
        _items = []
        if self.step_results:
            for _item in self.step_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stepResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in step_comments (list)
        _items = []
        if self.step_comments:
            for _item in self.step_comments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stepComments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup_results (list)
        _items = []
        if self.setup_results:
            for _item in self.setup_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setupResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown_results (list)
        _items = []
        if self.teardown_results:
            for _item in self.teardown_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teardownResults'] = _items
        # set to None if failure_class_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.failure_class_ids is None and "failure_class_ids" in self.__fields_set__:
            _dict['failureClassIds'] = None

        # set to None if outcome (nullable) is None
        # and __fields_set__ contains the field
        if self.outcome is None and "outcome" in self.__fields_set__:
            _dict['outcome'] = None

        # set to None if status_code (nullable) is None
        # and __fields_set__ contains the field
        if self.status_code is None and "status_code" in self.__fields_set__:
            _dict['statusCode'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if step_results (nullable) is None
        # and __fields_set__ contains the field
        if self.step_results is None and "step_results" in self.__fields_set__:
            _dict['stepResults'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if duration_in_ms (nullable) is None
        # and __fields_set__ contains the field
        if self.duration_in_ms is None and "duration_in_ms" in self.__fields_set__:
            _dict['durationInMs'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if step_comments (nullable) is None
        # and __fields_set__ contains the field
        if self.step_comments is None and "step_comments" in self.__fields_set__:
            _dict['stepComments'] = None

        # set to None if setup_results (nullable) is None
        # and __fields_set__ contains the field
        if self.setup_results is None and "setup_results" in self.__fields_set__:
            _dict['setupResults'] = None

        # set to None if teardown_results (nullable) is None
        # and __fields_set__ contains the field
        if self.teardown_results is None and "teardown_results" in self.__fields_set__:
            _dict['teardownResults'] = None

        # set to None if message (nullable) is None
        # and __fields_set__ contains the field
        if self.message is None and "message" in self.__fields_set__:
            _dict['message'] = None

        # set to None if trace (nullable) is None
        # and __fields_set__ contains the field
        if self.trace is None and "trace" in self.__fields_set__:
            _dict['trace'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultUpdateV2Request:
        """Create an instance of TestResultUpdateV2Request from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultUpdateV2Request.parse_obj(obj)

        _obj = TestResultUpdateV2Request.parse_obj({
            "failure_class_ids": obj.get("failureClassIds"),
            "outcome": obj.get("outcome"),
            "status_code": obj.get("statusCode"),
            "comment": obj.get("comment"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "step_results": [StepResultApiModel.from_dict(_item) for _item in obj.get("stepResults")] if obj.get("stepResults") is not None else None,
            "attachments": [AttachmentUpdateRequest.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "duration_in_ms": obj.get("durationInMs"),
            "duration": obj.get("duration"),
            "step_comments": [TestResultStepCommentUpdateRequest.from_dict(_item) for _item in obj.get("stepComments")] if obj.get("stepComments") is not None else None,
            "setup_results": [AutoTestStepResultUpdateRequest.from_dict(_item) for _item in obj.get("setupResults")] if obj.get("setupResults") is not None else None,
            "teardown_results": [AutoTestStepResultUpdateRequest.from_dict(_item) for _item in obj.get("teardownResults")] if obj.get("teardownResults") is not None else None,
            "message": obj.get("message"),
            "trace": obj.get("trace")
        })
        return _obj


