# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.attachment_update_request import AttachmentUpdateRequest

class TestResultStepCommentUpdateRequest(BaseModel):
    """
    TestResultStepCommentUpdateRequest
    """
    id: StrictStr = Field(default=..., description="Entity unique identifier")
    text: StrictStr = Field(...)
    step_id: StrictStr = Field(default=..., alias="stepId")
    parent_step_id: Optional[StrictStr] = Field(default=None, alias="parentStepId")
    attachments: conlist(AttachmentUpdateRequest) = Field(...)
    __properties = ["id", "text", "stepId", "parentStepId", "attachments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultStepCommentUpdateRequest:
        """Create an instance of TestResultStepCommentUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if parent_step_id (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_step_id is None and "parent_step_id" in self.__fields_set__:
            _dict['parentStepId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultStepCommentUpdateRequest:
        """Create an instance of TestResultStepCommentUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultStepCommentUpdateRequest.parse_obj(obj)

        _obj = TestResultStepCommentUpdateRequest.parse_obj({
            "id": obj.get("id"),
            "text": obj.get("text"),
            "step_id": obj.get("stepId"),
            "parent_step_id": obj.get("parentStepId"),
            "attachments": [AttachmentUpdateRequest.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None
        })
        return _obj


