# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from testit_api_client.models.attachment_api_result import AttachmentApiResult
from testit_api_client.models.auto_test_result_reason_short import AutoTestResultReasonShort
from testit_api_client.models.link_short import LinkShort
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestResultShortResponse(BaseModel):
    """
    TestResultShortResponse
    """
    id: StrictStr = Field(default=..., description="Unique ID of the test result")
    name: StrictStr = Field(default=..., description="Name of autotest represented by the test result")
    autotest_global_id: StrictInt = Field(default=..., alias="autotestGlobalId", description="Global ID of autotest represented by the test result")
    test_run_id: StrictStr = Field(default=..., alias="testRunId", description="Unique ID of test run where the test result is located")
    configuration_id: StrictStr = Field(default=..., alias="configurationId", description="Unique ID of configuration which the test result uses")
    configuration_name: StrictStr = Field(default=..., alias="configurationName", description="Name of configuration which the test result uses")
    outcome: Optional[StrictStr] = Field(default=None, description="Outcome of the test result")
    status: Optional[TestStatusApiResult] = None
    result_reasons: conlist(AutoTestResultReasonShort) = Field(default=..., alias="resultReasons", description="Collection of result reasons which the test result have")
    comment: Optional[StrictStr] = Field(default=None, description="Comment to the test result")
    var_date: datetime = Field(default=..., alias="date", description="Date when the test result was completed or started or created")
    created_date: datetime = Field(default=..., alias="createdDate", description="Date when the test result has been created")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate", description="Date when the test result has been modified")
    started_on: Optional[datetime] = Field(default=None, alias="startedOn", description="Date when the test result has been started")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn", description="Date when the test result has been completed")
    duration: Optional[StrictInt] = Field(default=None, description="Time which it took to run the test")
    links: conlist(LinkShort) = Field(default=..., description="Collection of links attached to the test result")
    attachments: conlist(AttachmentApiResult) = Field(default=..., description="Collection of files attached to the test result")
    rerun_completed_count: StrictInt = Field(default=..., alias="rerunCompletedCount", description="Run count")
    __properties = ["id", "name", "autotestGlobalId", "testRunId", "configurationId", "configurationName", "outcome", "status", "resultReasons", "comment", "date", "createdDate", "modifiedDate", "startedOn", "completedOn", "duration", "links", "attachments", "rerunCompletedCount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultShortResponse:
        """Create an instance of TestResultShortResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in result_reasons (list)
        _items = []
        if self.result_reasons:
            for _item in self.result_reasons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['resultReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if outcome (nullable) is None
        # and __fields_set__ contains the field
        if self.outcome is None and "outcome" in self.__fields_set__:
            _dict['outcome'] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict['status'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultShortResponse:
        """Create an instance of TestResultShortResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultShortResponse.parse_obj(obj)

        _obj = TestResultShortResponse.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "autotest_global_id": obj.get("autotestGlobalId"),
            "test_run_id": obj.get("testRunId"),
            "configuration_id": obj.get("configurationId"),
            "configuration_name": obj.get("configurationName"),
            "outcome": obj.get("outcome"),
            "status": TestStatusApiResult.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "result_reasons": [AutoTestResultReasonShort.from_dict(_item) for _item in obj.get("resultReasons")] if obj.get("resultReasons") is not None else None,
            "comment": obj.get("comment"),
            "var_date": obj.get("date"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "duration": obj.get("duration"),
            "links": [LinkShort.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "attachments": [AttachmentApiResult.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "rerun_completed_count": obj.get("rerunCompletedCount")
        })
        return _obj


