# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.attachment_api_result import AttachmentApiResult
from testit_api_client.models.auto_test_short_api_result import AutoTestShortApiResult
from testit_api_client.models.test_point_short_api_result import TestPointShortApiResult
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestResultShortApiResult(BaseModel):
    """
    TestResultShortApiResult
    """
    id: StrictStr = Field(...)
    outcome: StrictStr = Field(...)
    status: TestStatusApiResult = Field(...)
    traces: Optional[StrictStr] = None
    failure_type: Optional[StrictStr] = Field(default=None, alias="failureType")
    message: Optional[StrictStr] = None
    test_point: Optional[TestPointShortApiResult] = Field(default=None, alias="testPoint")
    created_date: datetime = Field(default=..., alias="createdDate")
    auto_test: Optional[AutoTestShortApiResult] = Field(default=None, alias="autoTest")
    attachments: conlist(AttachmentApiResult) = Field(...)
    __properties = ["id", "outcome", "status", "traces", "failureType", "message", "testPoint", "createdDate", "autoTest", "attachments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultShortApiResult:
        """Create an instance of TestResultShortApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of test_point
        if self.test_point:
            _dict['testPoint'] = self.test_point.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_test
        if self.auto_test:
            _dict['autoTest'] = self.auto_test.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if traces (nullable) is None
        # and __fields_set__ contains the field
        if self.traces is None and "traces" in self.__fields_set__:
            _dict['traces'] = None

        # set to None if failure_type (nullable) is None
        # and __fields_set__ contains the field
        if self.failure_type is None and "failure_type" in self.__fields_set__:
            _dict['failureType'] = None

        # set to None if message (nullable) is None
        # and __fields_set__ contains the field
        if self.message is None and "message" in self.__fields_set__:
            _dict['message'] = None

        # set to None if test_point (nullable) is None
        # and __fields_set__ contains the field
        if self.test_point is None and "test_point" in self.__fields_set__:
            _dict['testPoint'] = None

        # set to None if auto_test (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_test is None and "auto_test" in self.__fields_set__:
            _dict['autoTest'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultShortApiResult:
        """Create an instance of TestResultShortApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultShortApiResult.parse_obj(obj)

        _obj = TestResultShortApiResult.parse_obj({
            "id": obj.get("id"),
            "outcome": obj.get("outcome"),
            "status": TestStatusApiResult.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "traces": obj.get("traces"),
            "failure_type": obj.get("failureType"),
            "message": obj.get("message"),
            "test_point": TestPointShortApiResult.from_dict(obj.get("testPoint")) if obj.get("testPoint") is not None else None,
            "created_date": obj.get("createdDate"),
            "auto_test": AutoTestShortApiResult.from_dict(obj.get("autoTest")) if obj.get("autoTest") is not None else None,
            "attachments": [AttachmentApiResult.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None
        })
        return _obj


