# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.attachment_api_result import AttachmentApiResult
from testit_api_client.models.link_api_result import LinkApiResult
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestResultHistoryReportApiResult(BaseModel):
    """
    TestResultHistoryReportApiResult
    """
    id: StrictStr = Field(default=..., description="Internal test result identifier")
    created_date: datetime = Field(default=..., alias="createdDate", description="Test result creation date")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate", description="Test result last modification date")
    user_id: StrictStr = Field(default=..., alias="userId", description="Internal identifier of user who stopped test run related to the test result or user who created the test result                If test run was stopped, this property equals identifier of user who stopped it.  Otherwise, the property equals identifier of user who created the test result")
    test_run_id: Optional[StrictStr] = Field(default=None, alias="testRunId", description="Identifier of test run related to the test result")
    test_run_name: Optional[StrictStr] = Field(default=None, alias="testRunName", description="Name of test run related to the test result")
    created_by_user_name: Optional[StrictStr] = Field(default=None, alias="createdByUserName", description="Username of user who created test run")
    test_plan_id: Optional[StrictStr] = Field(default=None, alias="testPlanId", description="Internal identifier of test plan related to the test result's test run")
    test_plan_global_id: Optional[StrictInt] = Field(default=None, alias="testPlanGlobalId", description="Global identifier of test plan related to the test result's test run")
    test_plan_name: Optional[StrictStr] = Field(default=None, alias="testPlanName", description="Name of test plan related to the test result's test run")
    configuration_name: Optional[StrictStr] = Field(default=None, alias="configurationName", description="Configuration name of test point related to the test result or from test result itself                If test point related to the test result has configuration, this property will be equal to the test point configuration name.  Otherwise, this property will be equal to the test result configuration name")
    is_automated: StrictBool = Field(default=..., alias="isAutomated", description="Boolean flag defines if test point related to the test result is automated or not")
    outcome: Optional[StrictStr] = Field(default=None, description="Outcome from test result with max modified date or from first created test result                Property can contain one of these values: Passed, Failed, InProgress, Blocked, Skipped.                If any test result related to the test run is linked with autotest and the run has an outcome, the outcome value equals to the  worst outcome of the last modified test result. Otherwise, the outcome equals to the outcome of first created test result in the  test run.")
    status: TestStatusApiResult = Field(default=..., description="Status from test result with max modified date or from first created test result")
    comment: Optional[StrictStr] = Field(default=None, description="Test result comment                If any test result related to the test run is linked with autotest, comment will have default value.  Otherwise, the comment equals to the comment of first created test result in the test run")
    links: Optional[conlist(LinkApiResult)] = Field(default=None, description="Test result links                If any test result related to the test run is linked with autotest, link will be equal to the links of last modified test result.  Otherwise, the links equals to the links of first created test result in the test run.")
    started_on: Optional[datetime] = Field(default=None, alias="startedOn", description="Start date time from test result or from test run (if test run new state is Running or Completed state)")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn", description="End date time from test result or from test run (if test run new state is In progress, Stopped or Completed)")
    duration: Optional[StrictInt] = Field(default=None, description="Duration of first created test result in the test run")
    created_by_id: StrictStr = Field(default=..., alias="createdById", description="Unique identifier of user who created first test result in the test run")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById", description="Unique identifier of user who applied last modification of first test result in the test run")
    attachments: Optional[conlist(AttachmentApiResult)] = Field(default=None, description="Attachments related to the test result                If any test result related to the test run is linked with autotest, attachments will be equal to the attachments of last modified  test result. Otherwise, the attachments equals to the attachments of first created test result in the test run.")
    work_item_version_id: Optional[StrictStr] = Field(default=None, alias="workItemVersionId", description="Unique identifier of workitem version related to the first test result in the test run")
    work_item_version_number: Optional[StrictInt] = Field(default=None, alias="workItemVersionNumber", description="Number of workitem version related to the first test result in the test run")
    launch_source: Optional[StrictStr] = Field(default=None, alias="launchSource")
    failure_class_ids: conlist(StrictStr) = Field(default=..., alias="failureClassIds", description="Unique identifier of failure classes related to the first test result in the test run")
    parameters: Optional[Dict[str, StrictStr]] = Field(default=None, description="Parameters of test result")
    __properties = ["id", "createdDate", "modifiedDate", "userId", "testRunId", "testRunName", "createdByUserName", "testPlanId", "testPlanGlobalId", "testPlanName", "configurationName", "isAutomated", "outcome", "status", "comment", "links", "startedOn", "completedOn", "duration", "createdById", "modifiedById", "attachments", "workItemVersionId", "workItemVersionNumber", "launchSource", "failureClassIds", "parameters"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestResultHistoryReportApiResult:
        """Create an instance of TestResultHistoryReportApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if test_run_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_run_id is None and "test_run_id" in self.__fields_set__:
            _dict['testRunId'] = None

        # set to None if test_run_name (nullable) is None
        # and __fields_set__ contains the field
        if self.test_run_name is None and "test_run_name" in self.__fields_set__:
            _dict['testRunName'] = None

        # set to None if created_by_user_name (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_user_name is None and "created_by_user_name" in self.__fields_set__:
            _dict['createdByUserName'] = None

        # set to None if test_plan_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_id is None and "test_plan_id" in self.__fields_set__:
            _dict['testPlanId'] = None

        # set to None if test_plan_global_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_global_id is None and "test_plan_global_id" in self.__fields_set__:
            _dict['testPlanGlobalId'] = None

        # set to None if test_plan_name (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_name is None and "test_plan_name" in self.__fields_set__:
            _dict['testPlanName'] = None

        # set to None if configuration_name (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_name is None and "configuration_name" in self.__fields_set__:
            _dict['configurationName'] = None

        # set to None if outcome (nullable) is None
        # and __fields_set__ contains the field
        if self.outcome is None and "outcome" in self.__fields_set__:
            _dict['outcome'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if work_item_version_id (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_version_id is None and "work_item_version_id" in self.__fields_set__:
            _dict['workItemVersionId'] = None

        # set to None if work_item_version_number (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_version_number is None and "work_item_version_number" in self.__fields_set__:
            _dict['workItemVersionNumber'] = None

        # set to None if launch_source (nullable) is None
        # and __fields_set__ contains the field
        if self.launch_source is None and "launch_source" in self.__fields_set__:
            _dict['launchSource'] = None

        # set to None if parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.parameters is None and "parameters" in self.__fields_set__:
            _dict['parameters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestResultHistoryReportApiResult:
        """Create an instance of TestResultHistoryReportApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestResultHistoryReportApiResult.parse_obj(obj)

        _obj = TestResultHistoryReportApiResult.parse_obj({
            "id": obj.get("id"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "user_id": obj.get("userId"),
            "test_run_id": obj.get("testRunId"),
            "test_run_name": obj.get("testRunName"),
            "created_by_user_name": obj.get("createdByUserName"),
            "test_plan_id": obj.get("testPlanId"),
            "test_plan_global_id": obj.get("testPlanGlobalId"),
            "test_plan_name": obj.get("testPlanName"),
            "configuration_name": obj.get("configurationName"),
            "is_automated": obj.get("isAutomated"),
            "outcome": obj.get("outcome"),
            "status": TestStatusApiResult.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "comment": obj.get("comment"),
            "links": [LinkApiResult.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "duration": obj.get("duration"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "attachments": [AttachmentApiResult.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "work_item_version_id": obj.get("workItemVersionId"),
            "work_item_version_number": obj.get("workItemVersionNumber"),
            "launch_source": obj.get("launchSource"),
            "failure_class_ids": obj.get("failureClassIds"),
            "parameters": obj.get("parameters")
        })
        return _obj


