# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.iteration_model import IterationModel
from testit_api_client.models.last_test_result_model import LastTestResultModel
from testit_api_client.models.test_status_api_result import TestStatusApiResult
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel

class TestPointWithLastResultResponseModel(BaseModel):
    """
    TestPointWithLastResultResponseModel
    """
    id: StrictStr = Field(...)
    work_item_name: Optional[StrictStr] = Field(default=None, alias="workItemName")
    is_automated: StrictBool = Field(default=..., alias="isAutomated")
    tester_id: Optional[StrictStr] = Field(default=None, alias="testerId")
    work_item_id: StrictStr = Field(default=..., alias="workItemId")
    configuration_id: Optional[StrictStr] = Field(default=None, alias="configurationId")
    test_suite_id: StrictStr = Field(default=..., alias="testSuiteId")
    last_test_result: Optional[LastTestResultModel] = Field(default=None, alias="lastTestResult")
    status: Optional[StrictStr] = None
    status_model: Optional[TestStatusApiResult] = Field(default=None, alias="statusModel")
    work_item_global_id: Optional[StrictInt] = Field(default=None, alias="workItemGlobalId")
    work_item_entity_type_name: Optional[StrictStr] = Field(default=None, alias="workItemEntityTypeName")
    section_id: StrictStr = Field(default=..., alias="sectionId")
    section_name: Optional[StrictStr] = Field(default=None, alias="sectionName")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    attributes: Optional[Dict[str, Any]] = None
    tag_names: Optional[conlist(StrictStr)] = Field(default=None, alias="tagNames")
    duration: StrictInt = Field(...)
    priority: WorkItemPriorityModel = Field(...)
    test_suite_name_bread_crumbs: Optional[conlist(StrictStr)] = Field(default=None, alias="testSuiteNameBreadCrumbs")
    group_count: Optional[StrictInt] = Field(default=None, alias="groupCount")
    iteration: Optional[IterationModel] = None
    __properties = ["id", "workItemName", "isAutomated", "testerId", "workItemId", "configurationId", "testSuiteId", "lastTestResult", "status", "statusModel", "workItemGlobalId", "workItemEntityTypeName", "sectionId", "sectionName", "createdDate", "modifiedDate", "createdById", "modifiedById", "attributes", "tagNames", "duration", "priority", "testSuiteNameBreadCrumbs", "groupCount", "iteration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestPointWithLastResultResponseModel:
        """Create an instance of TestPointWithLastResultResponseModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of last_test_result
        if self.last_test_result:
            _dict['lastTestResult'] = self.last_test_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_model
        if self.status_model:
            _dict['statusModel'] = self.status_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of iteration
        if self.iteration:
            _dict['iteration'] = self.iteration.to_dict()
        # set to None if work_item_name (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_name is None and "work_item_name" in self.__fields_set__:
            _dict['workItemName'] = None

        # set to None if tester_id (nullable) is None
        # and __fields_set__ contains the field
        if self.tester_id is None and "tester_id" in self.__fields_set__:
            _dict['testerId'] = None

        # set to None if configuration_id (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_id is None and "configuration_id" in self.__fields_set__:
            _dict['configurationId'] = None

        # set to None if last_test_result (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_result is None and "last_test_result" in self.__fields_set__:
            _dict['lastTestResult'] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict['status'] = None

        # set to None if status_model (nullable) is None
        # and __fields_set__ contains the field
        if self.status_model is None and "status_model" in self.__fields_set__:
            _dict['statusModel'] = None

        # set to None if work_item_global_id (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_global_id is None and "work_item_global_id" in self.__fields_set__:
            _dict['workItemGlobalId'] = None

        # set to None if work_item_entity_type_name (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_entity_type_name is None and "work_item_entity_type_name" in self.__fields_set__:
            _dict['workItemEntityTypeName'] = None

        # set to None if section_name (nullable) is None
        # and __fields_set__ contains the field
        if self.section_name is None and "section_name" in self.__fields_set__:
            _dict['sectionName'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if attributes (nullable) is None
        # and __fields_set__ contains the field
        if self.attributes is None and "attributes" in self.__fields_set__:
            _dict['attributes'] = None

        # set to None if tag_names (nullable) is None
        # and __fields_set__ contains the field
        if self.tag_names is None and "tag_names" in self.__fields_set__:
            _dict['tagNames'] = None

        # set to None if test_suite_name_bread_crumbs (nullable) is None
        # and __fields_set__ contains the field
        if self.test_suite_name_bread_crumbs is None and "test_suite_name_bread_crumbs" in self.__fields_set__:
            _dict['testSuiteNameBreadCrumbs'] = None

        # set to None if group_count (nullable) is None
        # and __fields_set__ contains the field
        if self.group_count is None and "group_count" in self.__fields_set__:
            _dict['groupCount'] = None

        # set to None if iteration (nullable) is None
        # and __fields_set__ contains the field
        if self.iteration is None and "iteration" in self.__fields_set__:
            _dict['iteration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestPointWithLastResultResponseModel:
        """Create an instance of TestPointWithLastResultResponseModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestPointWithLastResultResponseModel.parse_obj(obj)

        _obj = TestPointWithLastResultResponseModel.parse_obj({
            "id": obj.get("id"),
            "work_item_name": obj.get("workItemName"),
            "is_automated": obj.get("isAutomated"),
            "tester_id": obj.get("testerId"),
            "work_item_id": obj.get("workItemId"),
            "configuration_id": obj.get("configurationId"),
            "test_suite_id": obj.get("testSuiteId"),
            "last_test_result": LastTestResultModel.from_dict(obj.get("lastTestResult")) if obj.get("lastTestResult") is not None else None,
            "status": obj.get("status"),
            "status_model": TestStatusApiResult.from_dict(obj.get("statusModel")) if obj.get("statusModel") is not None else None,
            "work_item_global_id": obj.get("workItemGlobalId"),
            "work_item_entity_type_name": obj.get("workItemEntityTypeName"),
            "section_id": obj.get("sectionId"),
            "section_name": obj.get("sectionName"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "attributes": obj.get("attributes"),
            "tag_names": obj.get("tagNames"),
            "duration": obj.get("duration"),
            "priority": obj.get("priority"),
            "test_suite_name_bread_crumbs": obj.get("testSuiteNameBreadCrumbs"),
            "group_count": obj.get("groupCount"),
            "iteration": IterationModel.from_dict(obj.get("iteration")) if obj.get("iteration") is not None else None
        })
        return _obj


