# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestPointShortApiResult(BaseModel):
    """
    TestPointShortApiResult
    """
    id: StrictStr = Field(default=..., description="Test point unique internal identifier")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Indicates if the entity is deleted")
    tester_id: Optional[StrictStr] = Field(default=None, alias="testerId", description="Tester who is responded for the test unique internal identifier")
    work_item_id: Optional[StrictStr] = Field(default=None, alias="workItemId", description="Workitem to which test point relates unique identifier")
    configuration_id: Optional[StrictStr] = Field(default=None, alias="configurationId", description="Configuration to which test point relates unique identifier")
    status: Optional[StrictStr] = Field(default=None, description="Test point status   Applies one of these values: Blocked, NoResults, Failed, Passed")
    status_model: TestStatusApiResult = Field(default=..., alias="statusModel", description="Test point status")
    last_test_result_id: Optional[StrictStr] = Field(default=None, alias="lastTestResultId", description="Last test result unique identifier")
    iteration_id: StrictStr = Field(default=..., alias="iterationId", description="Iteration unique identifier")
    work_item_median_duration: Optional[StrictInt] = Field(default=None, alias="workItemMedianDuration", description="Median duration of work item the test point represents")
    test_suite_id: StrictStr = Field(default=..., alias="testSuiteId", description="Test suite to which test point relates unique identifier")
    __properties = ["id", "isDeleted", "testerId", "workItemId", "configurationId", "status", "statusModel", "lastTestResultId", "iterationId", "workItemMedianDuration", "testSuiteId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestPointShortApiResult:
        """Create an instance of TestPointShortApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status_model
        if self.status_model:
            _dict['statusModel'] = self.status_model.to_dict()
        # set to None if tester_id (nullable) is None
        # and __fields_set__ contains the field
        if self.tester_id is None and "tester_id" in self.__fields_set__:
            _dict['testerId'] = None

        # set to None if work_item_id (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_id is None and "work_item_id" in self.__fields_set__:
            _dict['workItemId'] = None

        # set to None if configuration_id (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_id is None and "configuration_id" in self.__fields_set__:
            _dict['configurationId'] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict['status'] = None

        # set to None if last_test_result_id (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_result_id is None and "last_test_result_id" in self.__fields_set__:
            _dict['lastTestResultId'] = None

        # set to None if work_item_median_duration (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_median_duration is None and "work_item_median_duration" in self.__fields_set__:
            _dict['workItemMedianDuration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestPointShortApiResult:
        """Create an instance of TestPointShortApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestPointShortApiResult.parse_obj(obj)

        _obj = TestPointShortApiResult.parse_obj({
            "id": obj.get("id"),
            "is_deleted": obj.get("isDeleted"),
            "tester_id": obj.get("testerId"),
            "work_item_id": obj.get("workItemId"),
            "configuration_id": obj.get("configurationId"),
            "status": obj.get("status"),
            "status_model": TestStatusApiResult.from_dict(obj.get("statusModel")) if obj.get("statusModel") is not None else None,
            "last_test_result_id": obj.get("lastTestResultId"),
            "iteration_id": obj.get("iterationId"),
            "work_item_median_duration": obj.get("workItemMedianDuration"),
            "test_suite_id": obj.get("testSuiteId")
        })
        return _obj


