# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from testit_api_client.models.test_result_short_api_result import TestResultShortApiResult
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class TestPointResultApiResult(BaseModel):
    """
    TestPointResultApiResult
    """
    test_point_id: Optional[StrictStr] = Field(default=None, alias="testPointId")
    aggregated_outcome: Optional[StrictStr] = Field(default=None, alias="aggregatedOutcome")
    aggregated_status: Optional[TestStatusApiResult] = Field(default=None, alias="aggregatedStatus")
    work_item_global_id: Optional[StrictInt] = Field(default=None, alias="workItemGlobalId")
    work_item_name: Optional[StrictStr] = Field(default=None, alias="workItemName")
    configuration_name: Optional[StrictStr] = Field(default=None, alias="configurationName")
    test_results: conlist(TestResultShortApiResult) = Field(default=..., alias="testResults")
    __properties = ["testPointId", "aggregatedOutcome", "aggregatedStatus", "workItemGlobalId", "workItemName", "configurationName", "testResults"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestPointResultApiResult:
        """Create an instance of TestPointResultApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of aggregated_status
        if self.aggregated_status:
            _dict['aggregatedStatus'] = self.aggregated_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in test_results (list)
        _items = []
        if self.test_results:
            for _item in self.test_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['testResults'] = _items
        # set to None if test_point_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_point_id is None and "test_point_id" in self.__fields_set__:
            _dict['testPointId'] = None

        # set to None if aggregated_outcome (nullable) is None
        # and __fields_set__ contains the field
        if self.aggregated_outcome is None and "aggregated_outcome" in self.__fields_set__:
            _dict['aggregatedOutcome'] = None

        # set to None if aggregated_status (nullable) is None
        # and __fields_set__ contains the field
        if self.aggregated_status is None and "aggregated_status" in self.__fields_set__:
            _dict['aggregatedStatus'] = None

        # set to None if work_item_global_id (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_global_id is None and "work_item_global_id" in self.__fields_set__:
            _dict['workItemGlobalId'] = None

        # set to None if work_item_name (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_name is None and "work_item_name" in self.__fields_set__:
            _dict['workItemName'] = None

        # set to None if configuration_name (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_name is None and "configuration_name" in self.__fields_set__:
            _dict['configurationName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestPointResultApiResult:
        """Create an instance of TestPointResultApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestPointResultApiResult.parse_obj(obj)

        _obj = TestPointResultApiResult.parse_obj({
            "test_point_id": obj.get("testPointId"),
            "aggregated_outcome": obj.get("aggregatedOutcome"),
            "aggregated_status": TestStatusApiResult.from_dict(obj.get("aggregatedStatus")) if obj.get("aggregatedStatus") is not None else None,
            "work_item_global_id": obj.get("workItemGlobalId"),
            "work_item_name": obj.get("workItemName"),
            "configuration_name": obj.get("configurationName"),
            "test_results": [TestResultShortApiResult.from_dict(_item) for _item in obj.get("testResults")] if obj.get("testResults") is not None else None
        })
        return _obj


