# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.int64_range_selector_model import Int64RangeSelectorModel
from testit_api_client.models.test_point_status import TestPointStatus
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel

class TestPointFilterModel(BaseModel):
    """
    TestPointFilterModel
    """
    test_plan_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="testPlanIds", description="Specifies a test point test plan IDS to search for")
    test_suite_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="testSuiteIds", description="Specifies a test point test suite IDs to search for")
    work_item_global_ids: Optional[conlist(StrictInt)] = Field(default=None, alias="workItemGlobalIds", description="Specifies a test point work item global IDs to search for")
    work_item_median_duration: Optional[Int64RangeSelectorModel] = Field(default=None, alias="workItemMedianDuration", description="Specifies a test point work item median duration range to search for")
    work_item_is_deleted: Optional[StrictBool] = Field(default=None, alias="workItemIsDeleted", description="Specifies a test point work item is deleted flag to search for")
    statuses: Optional[conlist(TestPointStatus)] = Field(default=None, description="Specifies a test point statuses to search for")
    status_codes: Optional[conlist(StrictStr)] = Field(default=None, alias="statusCodes", description="Specifies a test point status codes to search for")
    priorities: Optional[conlist(WorkItemPriorityModel)] = Field(default=None, description="Specifies a test point priorities to search for")
    is_automated: Optional[StrictBool] = Field(default=None, alias="isAutomated", description="Specifies a test point automation status to search for")
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Specifies a test point name to search for")
    configuration_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="configurationIds", description="Specifies a test point configuration IDs to search for")
    tester_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="testerIds", description="Specifies a test point assigned user IDs to search for")
    duration: Optional[Int64RangeSelectorModel] = Field(default=None, description="Specifies a test point range of duration to search for")
    section_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="sectionIds", description="Specifies a test point work item section IDs to search for")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate", description="Specifies a test point range of creation date to search for")
    created_by_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="createdByIds", description="Specifies a test point creator IDs to search for")
    modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="modifiedDate", description="Specifies a test point range of last modification date to search for")
    modified_by_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="modifiedByIds", description="Specifies a test point last editor IDs to search for")
    tags: Optional[conlist(StrictStr)] = Field(default=None, description="Specifies a test point tags to search for")
    attributes: Optional[Dict[str, conlist(StrictStr, unique_items=True)]] = Field(default=None, description="Specifies a test point attributes to search for")
    work_item_created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="workItemCreatedDate", description="Specifies a work item range of creation date to search for")
    work_item_created_by_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="workItemCreatedByIds", description="Specifies a work item creator IDs to search for")
    work_item_modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="workItemModifiedDate", description="Specifies a work item range of last modification date to search for")
    work_item_modified_by_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="workItemModifiedByIds", description="Specifies a work item last editor IDs to search for")
    __properties = ["testPlanIds", "testSuiteIds", "workItemGlobalIds", "workItemMedianDuration", "workItemIsDeleted", "statuses", "statusCodes", "priorities", "isAutomated", "name", "configurationIds", "testerIds", "duration", "sectionIds", "createdDate", "createdByIds", "modifiedDate", "modifiedByIds", "tags", "attributes", "workItemCreatedDate", "workItemCreatedByIds", "workItemModifiedDate", "workItemModifiedByIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestPointFilterModel:
        """Create an instance of TestPointFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of work_item_median_duration
        if self.work_item_median_duration:
            _dict['workItemMedianDuration'] = self.work_item_median_duration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of duration
        if self.duration:
            _dict['duration'] = self.duration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modified_date
        if self.modified_date:
            _dict['modifiedDate'] = self.modified_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of work_item_created_date
        if self.work_item_created_date:
            _dict['workItemCreatedDate'] = self.work_item_created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of work_item_modified_date
        if self.work_item_modified_date:
            _dict['workItemModifiedDate'] = self.work_item_modified_date.to_dict()
        # set to None if test_plan_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_ids is None and "test_plan_ids" in self.__fields_set__:
            _dict['testPlanIds'] = None

        # set to None if test_suite_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.test_suite_ids is None and "test_suite_ids" in self.__fields_set__:
            _dict['testSuiteIds'] = None

        # set to None if work_item_global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_global_ids is None and "work_item_global_ids" in self.__fields_set__:
            _dict['workItemGlobalIds'] = None

        # set to None if work_item_median_duration (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_median_duration is None and "work_item_median_duration" in self.__fields_set__:
            _dict['workItemMedianDuration'] = None

        # set to None if work_item_is_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_is_deleted is None and "work_item_is_deleted" in self.__fields_set__:
            _dict['workItemIsDeleted'] = None

        # set to None if statuses (nullable) is None
        # and __fields_set__ contains the field
        if self.statuses is None and "statuses" in self.__fields_set__:
            _dict['statuses'] = None

        # set to None if status_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.status_codes is None and "status_codes" in self.__fields_set__:
            _dict['statusCodes'] = None

        # set to None if priorities (nullable) is None
        # and __fields_set__ contains the field
        if self.priorities is None and "priorities" in self.__fields_set__:
            _dict['priorities'] = None

        # set to None if is_automated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_automated is None and "is_automated" in self.__fields_set__:
            _dict['isAutomated'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if configuration_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration_ids is None and "configuration_ids" in self.__fields_set__:
            _dict['configurationIds'] = None

        # set to None if tester_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.tester_ids is None and "tester_ids" in self.__fields_set__:
            _dict['testerIds'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if section_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.section_ids is None and "section_ids" in self.__fields_set__:
            _dict['sectionIds'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_ids is None and "modified_by_ids" in self.__fields_set__:
            _dict['modifiedByIds'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        # set to None if attributes (nullable) is None
        # and __fields_set__ contains the field
        if self.attributes is None and "attributes" in self.__fields_set__:
            _dict['attributes'] = None

        # set to None if work_item_created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_created_date is None and "work_item_created_date" in self.__fields_set__:
            _dict['workItemCreatedDate'] = None

        # set to None if work_item_created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_created_by_ids is None and "work_item_created_by_ids" in self.__fields_set__:
            _dict['workItemCreatedByIds'] = None

        # set to None if work_item_modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_modified_date is None and "work_item_modified_date" in self.__fields_set__:
            _dict['workItemModifiedDate'] = None

        # set to None if work_item_modified_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_modified_by_ids is None and "work_item_modified_by_ids" in self.__fields_set__:
            _dict['workItemModifiedByIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestPointFilterModel:
        """Create an instance of TestPointFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestPointFilterModel.parse_obj(obj)

        _obj = TestPointFilterModel.parse_obj({
            "test_plan_ids": obj.get("testPlanIds"),
            "test_suite_ids": obj.get("testSuiteIds"),
            "work_item_global_ids": obj.get("workItemGlobalIds"),
            "work_item_median_duration": Int64RangeSelectorModel.from_dict(obj.get("workItemMedianDuration")) if obj.get("workItemMedianDuration") is not None else None,
            "work_item_is_deleted": obj.get("workItemIsDeleted"),
            "statuses": obj.get("statuses"),
            "status_codes": obj.get("statusCodes"),
            "priorities": obj.get("priorities"),
            "is_automated": obj.get("isAutomated"),
            "name": obj.get("name"),
            "configuration_ids": obj.get("configurationIds"),
            "tester_ids": obj.get("testerIds"),
            "duration": Int64RangeSelectorModel.from_dict(obj.get("duration")) if obj.get("duration") is not None else None,
            "section_ids": obj.get("sectionIds"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "created_by_ids": obj.get("createdByIds"),
            "modified_date": DateTimeRangeSelectorModel.from_dict(obj.get("modifiedDate")) if obj.get("modifiedDate") is not None else None,
            "modified_by_ids": obj.get("modifiedByIds"),
            "tags": obj.get("tags"),
            "attributes": obj.get("attributes"),
            "work_item_created_date": DateTimeRangeSelectorModel.from_dict(obj.get("workItemCreatedDate")) if obj.get("workItemCreatedDate") is not None else None,
            "work_item_created_by_ids": obj.get("workItemCreatedByIds"),
            "work_item_modified_date": DateTimeRangeSelectorModel.from_dict(obj.get("workItemModifiedDate")) if obj.get("workItemModifiedDate") is not None else None,
            "work_item_modified_by_ids": obj.get("workItemModifiedByIds")
        })
        return _obj


