# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr
from testit_api_client.models.tag_post_model import TagPostModel
from testit_api_client.models.test_plan_status_model import TestPlanStatusModel
from testit_api_client.models.test_point_analytic_result import TestPointAnalyticResult

class TestPlanWithAnalyticModel(BaseModel):
    """
    TestPlanWithAnalyticModel
    """
    analytic: TestPointAnalyticResult = Field(...)
    status: TestPlanStatusModel = Field(...)
    started_on: Optional[datetime] = Field(default=None, alias="startedOn", description="Set when test plan is starter (status changed to: In Progress)")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn", description="set when test plan status is completed (status changed to: Completed)")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    global_id: StrictInt = Field(default=..., alias="globalId", description="Used for search Test plan")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    locked_date: Optional[datetime] = Field(default=None, alias="lockedDate")
    id: StrictStr = Field(...)
    locked_by_id: Optional[StrictStr] = Field(default=None, alias="lockedById")
    tags: Optional[conlist(TagPostModel)] = None
    name: constr(strict=True, max_length=450, min_length=0) = Field(...)
    start_date: Optional[datetime] = Field(default=None, alias="startDate", description="Used for analytics")
    end_date: Optional[datetime] = Field(default=None, alias="endDate", description="Used for analytics")
    description: Optional[constr(strict=True, max_length=100000, min_length=0)] = None
    build: Optional[constr(strict=True, max_length=450, min_length=0)] = None
    project_id: StrictStr = Field(default=..., alias="projectId")
    product_name: Optional[constr(strict=True, max_length=450, min_length=0)] = Field(default=None, alias="productName")
    has_automatic_duration_timer: Optional[StrictBool] = Field(default=None, alias="hasAutomaticDurationTimer")
    attributes: Dict[str, Any] = Field(...)
    __properties = ["analytic", "status", "startedOn", "completedOn", "createdDate", "modifiedDate", "createdById", "modifiedById", "globalId", "isDeleted", "lockedDate", "id", "lockedById", "tags", "name", "startDate", "endDate", "description", "build", "projectId", "productName", "hasAutomaticDurationTimer", "attributes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TestPlanWithAnalyticModel:
        """Create an instance of TestPlanWithAnalyticModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of analytic
        if self.analytic:
            _dict['analytic'] = self.analytic.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if locked_date (nullable) is None
        # and __fields_set__ contains the field
        if self.locked_date is None and "locked_date" in self.__fields_set__:
            _dict['lockedDate'] = None

        # set to None if locked_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.locked_by_id is None and "locked_by_id" in self.__fields_set__:
            _dict['lockedById'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        # set to None if start_date (nullable) is None
        # and __fields_set__ contains the field
        if self.start_date is None and "start_date" in self.__fields_set__:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict['endDate'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if build (nullable) is None
        # and __fields_set__ contains the field
        if self.build is None and "build" in self.__fields_set__:
            _dict['build'] = None

        # set to None if product_name (nullable) is None
        # and __fields_set__ contains the field
        if self.product_name is None and "product_name" in self.__fields_set__:
            _dict['productName'] = None

        # set to None if has_automatic_duration_timer (nullable) is None
        # and __fields_set__ contains the field
        if self.has_automatic_duration_timer is None and "has_automatic_duration_timer" in self.__fields_set__:
            _dict['hasAutomaticDurationTimer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TestPlanWithAnalyticModel:
        """Create an instance of TestPlanWithAnalyticModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TestPlanWithAnalyticModel.parse_obj(obj)

        _obj = TestPlanWithAnalyticModel.parse_obj({
            "analytic": TestPointAnalyticResult.from_dict(obj.get("analytic")) if obj.get("analytic") is not None else None,
            "status": obj.get("status"),
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "global_id": obj.get("globalId"),
            "is_deleted": obj.get("isDeleted"),
            "locked_date": obj.get("lockedDate"),
            "id": obj.get("id"),
            "locked_by_id": obj.get("lockedById"),
            "tags": [TagPostModel.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None,
            "name": obj.get("name"),
            "start_date": obj.get("startDate"),
            "end_date": obj.get("endDate"),
            "description": obj.get("description"),
            "build": obj.get("build"),
            "project_id": obj.get("projectId"),
            "product_name": obj.get("productName"),
            "has_automatic_duration_timer": obj.get("hasAutomaticDurationTimer"),
            "attributes": obj.get("attributes")
        })
        return _obj


