# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.attachment_api_result import AttachmentApiResult

class StepCommentApiModel(BaseModel):
    """
    StepCommentApiModel
    """
    id: StrictStr = Field(...)
    text: Optional[StrictStr] = None
    step_id: StrictStr = Field(default=..., alias="stepId")
    parent_step_id: Optional[StrictStr] = Field(default=None, alias="parentStepId")
    attachments: conlist(AttachmentApiResult) = Field(...)
    test_result_id: StrictStr = Field(default=..., alias="testResultId")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    __properties = ["id", "text", "stepId", "parentStepId", "attachments", "testResultId", "createdById", "modifiedById", "createdDate", "modifiedDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StepCommentApiModel:
        """Create an instance of StepCommentApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if text (nullable) is None
        # and __fields_set__ contains the field
        if self.text is None and "text" in self.__fields_set__:
            _dict['text'] = None

        # set to None if parent_step_id (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_step_id is None and "parent_step_id" in self.__fields_set__:
            _dict['parentStepId'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StepCommentApiModel:
        """Create an instance of StepCommentApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StepCommentApiModel.parse_obj(obj)

        _obj = StepCommentApiModel.parse_obj({
            "id": obj.get("id"),
            "text": obj.get("text"),
            "step_id": obj.get("stepId"),
            "parent_step_id": obj.get("parentStepId"),
            "attachments": [AttachmentApiResult.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "test_result_id": obj.get("testResultId"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate")
        })
        return _obj


