# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel
from testit_api_client.models.work_item_states import WorkItemStates

class SharedStepReferencesQueryFilterModel(BaseModel):
    """
    SharedStepReferencesQueryFilterModel
    """
    name: Optional[StrictStr] = Field(default=None, description="Name of work item")
    global_ids: Optional[conlist(StrictInt, unique_items=True)] = Field(default=None, alias="globalIds", description="Collection of global (integer) identifiers")
    section_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="sectionIds", description="Collection of section identifiers")
    created_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="createdByIds", description="Collection of identifiers of users who created work item")
    modified_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="modifiedByIds", description="Collection of identifiers of users who applied last modification to work item")
    states: Optional[conlist(WorkItemStates, unique_items=True)] = Field(default=None, description="Collection of states of work item")
    priorities: Optional[conlist(WorkItemPriorityModel, unique_items=True)] = Field(default=None, description="Collection of priorities of work item")
    entity_types: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="entityTypes", description="Collection of types of work item   Allowed values: `TestCases`, `CheckLists`, `SharedSteps`")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate", description="Date and time of work item creation")
    modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="modifiedDate", description="Date and time of work item last modification")
    is_automated: Optional[StrictBool] = Field(default=None, alias="isAutomated", description="Is result must consist of only manual/automated work items")
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, description="Collection of tags")
    __properties = ["name", "globalIds", "sectionIds", "createdByIds", "modifiedByIds", "states", "priorities", "entityTypes", "createdDate", "modifiedDate", "isAutomated", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SharedStepReferencesQueryFilterModel:
        """Create an instance of SharedStepReferencesQueryFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modified_date
        if self.modified_date:
            _dict['modifiedDate'] = self.modified_date.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.global_ids is None and "global_ids" in self.__fields_set__:
            _dict['globalIds'] = None

        # set to None if section_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.section_ids is None and "section_ids" in self.__fields_set__:
            _dict['sectionIds'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if modified_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_ids is None and "modified_by_ids" in self.__fields_set__:
            _dict['modifiedByIds'] = None

        # set to None if states (nullable) is None
        # and __fields_set__ contains the field
        if self.states is None and "states" in self.__fields_set__:
            _dict['states'] = None

        # set to None if priorities (nullable) is None
        # and __fields_set__ contains the field
        if self.priorities is None and "priorities" in self.__fields_set__:
            _dict['priorities'] = None

        # set to None if entity_types (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_types is None and "entity_types" in self.__fields_set__:
            _dict['entityTypes'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if is_automated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_automated is None and "is_automated" in self.__fields_set__:
            _dict['isAutomated'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SharedStepReferencesQueryFilterModel:
        """Create an instance of SharedStepReferencesQueryFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SharedStepReferencesQueryFilterModel.parse_obj(obj)

        _obj = SharedStepReferencesQueryFilterModel.parse_obj({
            "name": obj.get("name"),
            "global_ids": obj.get("globalIds"),
            "section_ids": obj.get("sectionIds"),
            "created_by_ids": obj.get("createdByIds"),
            "modified_by_ids": obj.get("modifiedByIds"),
            "states": obj.get("states"),
            "priorities": obj.get("priorities"),
            "entity_types": obj.get("entityTypes"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "modified_date": DateTimeRangeSelectorModel.from_dict(obj.get("modifiedDate")) if obj.get("modifiedDate") is not None else None,
            "is_automated": obj.get("isAutomated"),
            "tags": obj.get("tags")
        })
        return _obj


