# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel

class SharedStepReferenceSectionsQueryFilterModel(BaseModel):
    """
    SharedStepReferenceSectionsQueryFilterModel
    """
    name: Optional[StrictStr] = Field(default=None, description="Name of section")
    created_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="createdByIds", description="Collection of identifiers of users who created work item")
    modified_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="modifiedByIds", description="Collection of identifiers of users who applied last modification to work item")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate", description="Date and time of work item creation")
    modified_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="modifiedDate", description="Date and time of work item last modification")
    __properties = ["name", "createdByIds", "modifiedByIds", "createdDate", "modifiedDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SharedStepReferenceSectionsQueryFilterModel:
        """Create an instance of SharedStepReferenceSectionsQueryFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modified_date
        if self.modified_date:
            _dict['modifiedDate'] = self.modified_date.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if modified_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_ids is None and "modified_by_ids" in self.__fields_set__:
            _dict['modifiedByIds'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SharedStepReferenceSectionsQueryFilterModel:
        """Create an instance of SharedStepReferenceSectionsQueryFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SharedStepReferenceSectionsQueryFilterModel.parse_obj(obj)

        _obj = SharedStepReferenceSectionsQueryFilterModel.parse_obj({
            "name": obj.get("name"),
            "created_by_ids": obj.get("createdByIds"),
            "modified_by_ids": obj.get("modifiedByIds"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "modified_date": DateTimeRangeSelectorModel.from_dict(obj.get("modifiedDate")) if obj.get("modifiedDate") is not None else None
        })
        return _obj


