# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.tag_model import TagModel
from testit_api_client.models.work_item_priority_model import WorkItemPriorityModel

class SharedStepReferenceModel(BaseModel):
    """
    SharedStepReferenceModel
    """
    id: StrictStr = Field(...)
    global_id: StrictInt = Field(default=..., alias="globalId")
    name: StrictStr = Field(...)
    entity_type_name: StrictStr = Field(default=..., alias="entityTypeName")
    has_this_shared_step_as_step: StrictBool = Field(default=..., alias="hasThisSharedStepAsStep")
    has_this_shared_step_as_precondition: StrictBool = Field(default=..., alias="hasThisSharedStepAsPrecondition")
    has_this_shared_step_as_postcondition: StrictBool = Field(default=..., alias="hasThisSharedStepAsPostcondition")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    state: StrictStr = Field(...)
    priority: WorkItemPriorityModel = Field(...)
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    version_id: StrictStr = Field(default=..., alias="versionId", description="used for versioning changes in workitem")
    is_automated: StrictBool = Field(default=..., alias="isAutomated")
    section_id: StrictStr = Field(default=..., alias="sectionId")
    tags: Optional[conlist(TagModel)] = None
    __properties = ["id", "globalId", "name", "entityTypeName", "hasThisSharedStepAsStep", "hasThisSharedStepAsPrecondition", "hasThisSharedStepAsPostcondition", "createdById", "modifiedById", "createdDate", "modifiedDate", "state", "priority", "isDeleted", "versionId", "isAutomated", "sectionId", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SharedStepReferenceModel:
        """Create an instance of SharedStepReferenceModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SharedStepReferenceModel:
        """Create an instance of SharedStepReferenceModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SharedStepReferenceModel.parse_obj(obj)

        _obj = SharedStepReferenceModel.parse_obj({
            "id": obj.get("id"),
            "global_id": obj.get("globalId"),
            "name": obj.get("name"),
            "entity_type_name": obj.get("entityTypeName"),
            "has_this_shared_step_as_step": obj.get("hasThisSharedStepAsStep"),
            "has_this_shared_step_as_precondition": obj.get("hasThisSharedStepAsPrecondition"),
            "has_this_shared_step_as_postcondition": obj.get("hasThisSharedStepAsPostcondition"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "state": obj.get("state"),
            "priority": obj.get("priority"),
            "is_deleted": obj.get("isDeleted"),
            "version_id": obj.get("versionId"),
            "is_automated": obj.get("isAutomated"),
            "section_id": obj.get("sectionId"),
            "tags": [TagModel.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


