# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from testit_api_client.models.attachment_put_model import AttachmentPutModel
from testit_api_client.models.step_put_model import StepPutModel

class SectionPutModel(BaseModel):
    """
    SectionPutModel
    """
    id: StrictStr = Field(...)
    name: constr(strict=True, max_length=255, min_length=0) = Field(...)
    project_id: StrictStr = Field(default=..., alias="projectId")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    precondition_steps: Optional[conlist(StepPutModel)] = Field(default=None, alias="preconditionSteps")
    postcondition_steps: Optional[conlist(StepPutModel)] = Field(default=None, alias="postconditionSteps")
    attachments: conlist(AttachmentPutModel) = Field(...)
    __properties = ["id", "name", "projectId", "parentId", "preconditionSteps", "postconditionSteps", "attachments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SectionPutModel:
        """Create an instance of SectionPutModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in precondition_steps (list)
        _items = []
        if self.precondition_steps:
            for _item in self.precondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['preconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in postcondition_steps (list)
        _items = []
        if self.postcondition_steps:
            for _item in self.postcondition_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['postconditionSteps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if parent_id (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_id is None and "parent_id" in self.__fields_set__:
            _dict['parentId'] = None

        # set to None if precondition_steps (nullable) is None
        # and __fields_set__ contains the field
        if self.precondition_steps is None and "precondition_steps" in self.__fields_set__:
            _dict['preconditionSteps'] = None

        # set to None if postcondition_steps (nullable) is None
        # and __fields_set__ contains the field
        if self.postcondition_steps is None and "postcondition_steps" in self.__fields_set__:
            _dict['postconditionSteps'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SectionPutModel:
        """Create an instance of SectionPutModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SectionPutModel.parse_obj(obj)

        _obj = SectionPutModel.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "project_id": obj.get("projectId"),
            "parent_id": obj.get("parentId"),
            "precondition_steps": [StepPutModel.from_dict(_item) for _item in obj.get("preconditionSteps")] if obj.get("preconditionSteps") is not None else None,
            "postcondition_steps": [StepPutModel.from_dict(_item) for _item in obj.get("postconditionSteps")] if obj.get("postconditionSteps") is not None else None,
            "attachments": [AttachmentPutModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None
        })
        return _obj


