# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class SectionMoveModel(BaseModel):
    """
    SectionMoveModel
    """
    id: StrictStr = Field(default=..., description="Unique ID of the section")
    old_parent_id: StrictStr = Field(default=..., alias="oldParentId", description="Unique ID of the section's current parent section")
    parent_id: StrictStr = Field(default=..., alias="parentId", description="Unique ID of the section's target parent section")
    next_section_id: Optional[StrictStr] = Field(default=None, alias="nextSectionId", description="Unique ID of the section's following section")
    __properties = ["id", "oldParentId", "parentId", "nextSectionId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SectionMoveModel:
        """Create an instance of SectionMoveModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if next_section_id (nullable) is None
        # and __fields_set__ contains the field
        if self.next_section_id is None and "next_section_id" in self.__fields_set__:
            _dict['nextSectionId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SectionMoveModel:
        """Create an instance of SectionMoveModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SectionMoveModel.parse_obj(obj)

        _obj = SectionMoveModel.parse_obj({
            "id": obj.get("id"),
            "old_parent_id": obj.get("oldParentId"),
            "parent_id": obj.get("parentId"),
            "next_section_id": obj.get("nextSectionId")
        })
        return _obj


