# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr

class SectionModel(BaseModel):
    """
    SectionModel
    """
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    id: StrictStr = Field(...)
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    name: constr(strict=True, min_length=1) = Field(...)
    __properties = ["projectId", "parentId", "isDeleted", "id", "createdDate", "modifiedDate", "createdById", "modifiedById", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SectionModel:
        """Create an instance of SectionModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if project_id (nullable) is None
        # and __fields_set__ contains the field
        if self.project_id is None and "project_id" in self.__fields_set__:
            _dict['projectId'] = None

        # set to None if parent_id (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_id is None and "parent_id" in self.__fields_set__:
            _dict['parentId'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SectionModel:
        """Create an instance of SectionModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SectionModel.parse_obj(obj)

        _obj = SectionModel.parse_obj({
            "project_id": obj.get("projectId"),
            "parent_id": obj.get("parentId"),
            "is_deleted": obj.get("isDeleted"),
            "id": obj.get("id"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "name": obj.get("name")
        })
        return _obj


