# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.test_run_state import TestRunState

class SearchTestRunsApiModel(BaseModel):
    """
    SearchTestRunsApiModel
    """
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    states: Optional[conlist(TestRunState, unique_items=True)] = None
    status_codes: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="statusCodes")
    started_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="startedDate")
    completed_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="completedDate")
    created_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="createdByIds")
    modified_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="modifiedByIds")
    __properties = ["name", "states", "statusCodes", "startedDate", "completedDate", "createdByIds", "modifiedByIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchTestRunsApiModel:
        """Create an instance of SearchTestRunsApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of started_date
        if self.started_date:
            _dict['startedDate'] = self.started_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of completed_date
        if self.completed_date:
            _dict['completedDate'] = self.completed_date.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if states (nullable) is None
        # and __fields_set__ contains the field
        if self.states is None and "states" in self.__fields_set__:
            _dict['states'] = None

        # set to None if status_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.status_codes is None and "status_codes" in self.__fields_set__:
            _dict['statusCodes'] = None

        # set to None if started_date (nullable) is None
        # and __fields_set__ contains the field
        if self.started_date is None and "started_date" in self.__fields_set__:
            _dict['startedDate'] = None

        # set to None if completed_date (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_date is None and "completed_date" in self.__fields_set__:
            _dict['completedDate'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if modified_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_ids is None and "modified_by_ids" in self.__fields_set__:
            _dict['modifiedByIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchTestRunsApiModel:
        """Create an instance of SearchTestRunsApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchTestRunsApiModel.parse_obj(obj)

        _obj = SearchTestRunsApiModel.parse_obj({
            "name": obj.get("name"),
            "states": obj.get("states"),
            "status_codes": obj.get("statusCodes"),
            "started_date": DateTimeRangeSelectorModel.from_dict(obj.get("startedDate")) if obj.get("startedDate") is not None else None,
            "completed_date": DateTimeRangeSelectorModel.from_dict(obj.get("completedDate")) if obj.get("completedDate") is not None else None,
            "created_by_ids": obj.get("createdByIds"),
            "modified_by_ids": obj.get("modifiedByIds")
        })
        return _obj


