# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from testit_api_client.models.auto_test_model import AutoTestModel
from testit_api_client.models.configuration_model import ConfigurationModel
from testit_api_client.models.public_test_point_model import PublicTestPointModel

class PublicTestRunModel(BaseModel):
    """
    PublicTestRunModel
    """
    test_run_id: StrictStr = Field(default=..., alias="testRunId")
    test_plan_id: Optional[StrictStr] = Field(default=None, alias="testPlanId")
    test_plan_global_id: StrictInt = Field(default=..., alias="testPlanGlobalId")
    name: StrictStr = Field(...)
    product_name: Optional[StrictStr] = Field(default=None, alias="productName")
    build: Optional[StrictStr] = None
    configurations: conlist(ConfigurationModel) = Field(...)
    auto_tests: conlist(AutoTestModel) = Field(default=..., alias="autoTests")
    test_points: conlist(PublicTestPointModel) = Field(default=..., alias="testPoints")
    status: StrictStr = Field(...)
    custom_parameters: Optional[Dict[str, StrictStr]] = Field(default=None, alias="customParameters")
    test_run_description: Optional[StrictStr] = Field(default=None, alias="testRunDescription")
    __properties = ["testRunId", "testPlanId", "testPlanGlobalId", "name", "productName", "build", "configurations", "autoTests", "testPoints", "status", "customParameters", "testRunDescription"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PublicTestRunModel:
        """Create an instance of PublicTestRunModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in configurations (list)
        _items = []
        if self.configurations:
            for _item in self.configurations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['configurations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in auto_tests (list)
        _items = []
        if self.auto_tests:
            for _item in self.auto_tests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['autoTests'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in test_points (list)
        _items = []
        if self.test_points:
            for _item in self.test_points:
                if _item:
                    _items.append(_item.to_dict())
            _dict['testPoints'] = _items
        # set to None if test_plan_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_id is None and "test_plan_id" in self.__fields_set__:
            _dict['testPlanId'] = None

        # set to None if product_name (nullable) is None
        # and __fields_set__ contains the field
        if self.product_name is None and "product_name" in self.__fields_set__:
            _dict['productName'] = None

        # set to None if build (nullable) is None
        # and __fields_set__ contains the field
        if self.build is None and "build" in self.__fields_set__:
            _dict['build'] = None

        # set to None if custom_parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.custom_parameters is None and "custom_parameters" in self.__fields_set__:
            _dict['customParameters'] = None

        # set to None if test_run_description (nullable) is None
        # and __fields_set__ contains the field
        if self.test_run_description is None and "test_run_description" in self.__fields_set__:
            _dict['testRunDescription'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PublicTestRunModel:
        """Create an instance of PublicTestRunModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PublicTestRunModel.parse_obj(obj)

        _obj = PublicTestRunModel.parse_obj({
            "test_run_id": obj.get("testRunId"),
            "test_plan_id": obj.get("testPlanId"),
            "test_plan_global_id": obj.get("testPlanGlobalId"),
            "name": obj.get("name"),
            "product_name": obj.get("productName"),
            "build": obj.get("build"),
            "configurations": [ConfigurationModel.from_dict(_item) for _item in obj.get("configurations")] if obj.get("configurations") is not None else None,
            "auto_tests": [AutoTestModel.from_dict(_item) for _item in obj.get("autoTests")] if obj.get("autoTests") is not None else None,
            "test_points": [PublicTestPointModel.from_dict(_item) for _item in obj.get("testPoints")] if obj.get("testPoints") is not None else None,
            "status": obj.get("status"),
            "custom_parameters": obj.get("customParameters"),
            "test_run_description": obj.get("testRunDescription")
        })
        return _obj


