# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.int32_range_selector_model import Int32RangeSelectorModel
from testit_api_client.models.project_type_model import ProjectTypeModel

class ProjectsFilterModel(BaseModel):
    """
    ProjectsFilterModel
    """
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Specifies a project name to search for")
    is_favorite: Optional[StrictBool] = Field(default=None, alias="isFavorite", description="Specifies a project favorite status to search for")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted", description="Specifies a project deleted status to search for")
    test_cases_count: Optional[Int32RangeSelectorModel] = Field(default=None, alias="testCasesCount", description="Specifies a project range of test cases count to search for")
    checklists_count: Optional[Int32RangeSelectorModel] = Field(default=None, alias="checklistsCount", description="Specifies a project range of checklists count to search for")
    shared_steps_count: Optional[Int32RangeSelectorModel] = Field(default=None, alias="sharedStepsCount", description="Specifies a project range of shared steps count to search for")
    autotests_count: Optional[Int32RangeSelectorModel] = Field(default=None, alias="autotestsCount", description="Specifies a project range of autotests count to search for")
    global_ids: Optional[conlist(StrictInt, unique_items=True)] = Field(default=None, alias="globalIds", description="Specifies a project global IDs to search for")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate", description="Specifies a project range of creation date to search for")
    created_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="createdByIds", description="Specifies an autotest creator IDs to search for")
    types: Optional[conlist(ProjectTypeModel, unique_items=True)] = Field(default=None, description="Collection of project types to search for")
    __properties = ["name", "isFavorite", "isDeleted", "testCasesCount", "checklistsCount", "sharedStepsCount", "autotestsCount", "globalIds", "createdDate", "createdByIds", "types"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectsFilterModel:
        """Create an instance of ProjectsFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of test_cases_count
        if self.test_cases_count:
            _dict['testCasesCount'] = self.test_cases_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of checklists_count
        if self.checklists_count:
            _dict['checklistsCount'] = self.checklists_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shared_steps_count
        if self.shared_steps_count:
            _dict['sharedStepsCount'] = self.shared_steps_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of autotests_count
        if self.autotests_count:
            _dict['autotestsCount'] = self.autotests_count.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if is_favorite (nullable) is None
        # and __fields_set__ contains the field
        if self.is_favorite is None and "is_favorite" in self.__fields_set__:
            _dict['isFavorite'] = None

        # set to None if is_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.is_deleted is None and "is_deleted" in self.__fields_set__:
            _dict['isDeleted'] = None

        # set to None if test_cases_count (nullable) is None
        # and __fields_set__ contains the field
        if self.test_cases_count is None and "test_cases_count" in self.__fields_set__:
            _dict['testCasesCount'] = None

        # set to None if checklists_count (nullable) is None
        # and __fields_set__ contains the field
        if self.checklists_count is None and "checklists_count" in self.__fields_set__:
            _dict['checklistsCount'] = None

        # set to None if shared_steps_count (nullable) is None
        # and __fields_set__ contains the field
        if self.shared_steps_count is None and "shared_steps_count" in self.__fields_set__:
            _dict['sharedStepsCount'] = None

        # set to None if autotests_count (nullable) is None
        # and __fields_set__ contains the field
        if self.autotests_count is None and "autotests_count" in self.__fields_set__:
            _dict['autotestsCount'] = None

        # set to None if global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.global_ids is None and "global_ids" in self.__fields_set__:
            _dict['globalIds'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if types (nullable) is None
        # and __fields_set__ contains the field
        if self.types is None and "types" in self.__fields_set__:
            _dict['types'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectsFilterModel:
        """Create an instance of ProjectsFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectsFilterModel.parse_obj(obj)

        _obj = ProjectsFilterModel.parse_obj({
            "name": obj.get("name"),
            "is_favorite": obj.get("isFavorite"),
            "is_deleted": obj.get("isDeleted"),
            "test_cases_count": Int32RangeSelectorModel.from_dict(obj.get("testCasesCount")) if obj.get("testCasesCount") is not None else None,
            "checklists_count": Int32RangeSelectorModel.from_dict(obj.get("checklistsCount")) if obj.get("checklistsCount") is not None else None,
            "shared_steps_count": Int32RangeSelectorModel.from_dict(obj.get("sharedStepsCount")) if obj.get("sharedStepsCount") is not None else None,
            "autotests_count": Int32RangeSelectorModel.from_dict(obj.get("autotestsCount")) if obj.get("autotestsCount") is not None else None,
            "global_ids": obj.get("globalIds"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "created_by_ids": obj.get("createdByIds"),
            "types": obj.get("types")
        })
        return _obj


