# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr
from testit_api_client.models.date_time_range_selector_model import DateTimeRangeSelectorModel
from testit_api_client.models.test_plan_status_model import TestPlanStatusModel

class ProjectTestPlansFilterModel(BaseModel):
    """
    ProjectTestPlansFilterModel
    """
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    description: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    build: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    product_name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, alias="productName")
    status: Optional[conlist(TestPlanStatusModel, unique_items=True)] = None
    global_ids: Optional[conlist(StrictInt, unique_items=True)] = Field(default=None, alias="globalIds")
    is_locked: Optional[StrictBool] = Field(default=None, alias="isLocked")
    locked_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="lockedDate")
    automatic_duration_timer: Optional[conlist(StrictBool, unique_items=True)] = Field(default=None, alias="automaticDurationTimer")
    created_by_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="createdByIds")
    created_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="createdDate")
    start_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="startDate")
    end_date: Optional[DateTimeRangeSelectorModel] = Field(default=None, alias="endDate")
    tag_names: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="tagNames")
    attributes: Optional[Dict[str, conlist(StrictStr, unique_items=True)]] = None
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    __properties = ["name", "description", "build", "productName", "status", "globalIds", "isLocked", "lockedDate", "automaticDurationTimer", "createdByIds", "createdDate", "startDate", "endDate", "tagNames", "attributes", "isDeleted"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectTestPlansFilterModel:
        """Create an instance of ProjectTestPlansFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of locked_date
        if self.locked_date:
            _dict['lockedDate'] = self.locked_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_date
        if self.created_date:
            _dict['createdDate'] = self.created_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of start_date
        if self.start_date:
            _dict['startDate'] = self.start_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of end_date
        if self.end_date:
            _dict['endDate'] = self.end_date.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if build (nullable) is None
        # and __fields_set__ contains the field
        if self.build is None and "build" in self.__fields_set__:
            _dict['build'] = None

        # set to None if product_name (nullable) is None
        # and __fields_set__ contains the field
        if self.product_name is None and "product_name" in self.__fields_set__:
            _dict['productName'] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict['status'] = None

        # set to None if global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.global_ids is None and "global_ids" in self.__fields_set__:
            _dict['globalIds'] = None

        # set to None if is_locked (nullable) is None
        # and __fields_set__ contains the field
        if self.is_locked is None and "is_locked" in self.__fields_set__:
            _dict['isLocked'] = None

        # set to None if locked_date (nullable) is None
        # and __fields_set__ contains the field
        if self.locked_date is None and "locked_date" in self.__fields_set__:
            _dict['lockedDate'] = None

        # set to None if automatic_duration_timer (nullable) is None
        # and __fields_set__ contains the field
        if self.automatic_duration_timer is None and "automatic_duration_timer" in self.__fields_set__:
            _dict['automaticDurationTimer'] = None

        # set to None if created_by_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_ids is None and "created_by_ids" in self.__fields_set__:
            _dict['createdByIds'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if start_date (nullable) is None
        # and __fields_set__ contains the field
        if self.start_date is None and "start_date" in self.__fields_set__:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict['endDate'] = None

        # set to None if tag_names (nullable) is None
        # and __fields_set__ contains the field
        if self.tag_names is None and "tag_names" in self.__fields_set__:
            _dict['tagNames'] = None

        # set to None if attributes (nullable) is None
        # and __fields_set__ contains the field
        if self.attributes is None and "attributes" in self.__fields_set__:
            _dict['attributes'] = None

        # set to None if is_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.is_deleted is None and "is_deleted" in self.__fields_set__:
            _dict['isDeleted'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectTestPlansFilterModel:
        """Create an instance of ProjectTestPlansFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectTestPlansFilterModel.parse_obj(obj)

        _obj = ProjectTestPlansFilterModel.parse_obj({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "build": obj.get("build"),
            "product_name": obj.get("productName"),
            "status": obj.get("status"),
            "global_ids": obj.get("globalIds"),
            "is_locked": obj.get("isLocked"),
            "locked_date": DateTimeRangeSelectorModel.from_dict(obj.get("lockedDate")) if obj.get("lockedDate") is not None else None,
            "automatic_duration_timer": obj.get("automaticDurationTimer"),
            "created_by_ids": obj.get("createdByIds"),
            "created_date": DateTimeRangeSelectorModel.from_dict(obj.get("createdDate")) if obj.get("createdDate") is not None else None,
            "start_date": DateTimeRangeSelectorModel.from_dict(obj.get("startDate")) if obj.get("startDate") is not None else None,
            "end_date": DateTimeRangeSelectorModel.from_dict(obj.get("endDate")) if obj.get("endDate") is not None else None,
            "tag_names": obj.get("tagNames"),
            "attributes": obj.get("attributes"),
            "is_deleted": obj.get("isDeleted")
        })
        return _obj


