# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from testit_api_client.models.custom_attribute_model import CustomAttributeModel

class ProjectCustomAttributeTemplateGetModel(BaseModel):
    """
    ProjectCustomAttributeTemplateGetModel
    """
    id: StrictStr = Field(default=..., description="Unique ID of the custom attributes template")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Indicates if the custom attribute template is deleted")
    name: StrictStr = Field(default=..., description="Name of the custom attribute template")
    custom_attribute_models: conlist(CustomAttributeModel) = Field(default=..., alias="customAttributeModels", description="Attributes of the template")
    __properties = ["id", "isDeleted", "name", "customAttributeModels"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectCustomAttributeTemplateGetModel:
        """Create an instance of ProjectCustomAttributeTemplateGetModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in custom_attribute_models (list)
        _items = []
        if self.custom_attribute_models:
            for _item in self.custom_attribute_models:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customAttributeModels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectCustomAttributeTemplateGetModel:
        """Create an instance of ProjectCustomAttributeTemplateGetModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectCustomAttributeTemplateGetModel.parse_obj(obj)

        _obj = ProjectCustomAttributeTemplateGetModel.parse_obj({
            "id": obj.get("id"),
            "is_deleted": obj.get("isDeleted"),
            "name": obj.get("name"),
            "custom_attribute_models": [CustomAttributeModel.from_dict(_item) for _item in obj.get("customAttributeModels")] if obj.get("customAttributeModels") is not None else None
        })
        return _obj


