# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from testit_api_client.models.custom_attribute_types_enum import CustomAttributeTypesEnum

class ProjectAttributesFilterModel(BaseModel):
    """
    ProjectAttributesFilterModel
    """
    name: StrictStr = Field(default=..., description="Specifies an attribute name to search for")
    is_required: Optional[StrictBool] = Field(default=None, alias="isRequired", description="Specifies an attribute mandatory status to search for")
    is_global: Optional[StrictBool] = Field(default=None, alias="isGlobal", description="Specifies an attribute global status to search for")
    types: conlist(CustomAttributeTypesEnum, unique_items=True) = Field(default=..., description="Specifies an attribute types to search for")
    is_enabled: Optional[StrictBool] = Field(default=None, alias="isEnabled", description="Specifies an attribute enabled status to search for")
    __properties = ["name", "isRequired", "isGlobal", "types", "isEnabled"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectAttributesFilterModel:
        """Create an instance of ProjectAttributesFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if is_required (nullable) is None
        # and __fields_set__ contains the field
        if self.is_required is None and "is_required" in self.__fields_set__:
            _dict['isRequired'] = None

        # set to None if is_global (nullable) is None
        # and __fields_set__ contains the field
        if self.is_global is None and "is_global" in self.__fields_set__:
            _dict['isGlobal'] = None

        # set to None if is_enabled (nullable) is None
        # and __fields_set__ contains the field
        if self.is_enabled is None and "is_enabled" in self.__fields_set__:
            _dict['isEnabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectAttributesFilterModel:
        """Create an instance of ProjectAttributesFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectAttributesFilterModel.parse_obj(obj)

        _obj = ProjectAttributesFilterModel.parse_obj({
            "name": obj.get("name"),
            "is_required": obj.get("isRequired"),
            "is_global": obj.get("isGlobal"),
            "types": obj.get("types"),
            "is_enabled": obj.get("isEnabled")
        })
        return _obj


