# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr

class ParameterModel(BaseModel):
    """
    ParameterModel
    """
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    parameter_key_id: StrictStr = Field(default=..., alias="parameterKeyId")
    id: StrictStr = Field(...)
    value: constr(strict=True, max_length=1500, min_length=0) = Field(default=..., description="Value of the parameter")
    name: constr(strict=True, max_length=255, min_length=0) = Field(default=..., description="Key of the parameter")
    __properties = ["createdDate", "modifiedDate", "createdById", "modifiedById", "isDeleted", "parameterKeyId", "id", "value", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParameterModel:
        """Create an instance of ParameterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParameterModel:
        """Create an instance of ParameterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParameterModel.parse_obj(obj)

        _obj = ParameterModel.parse_obj({
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "is_deleted": obj.get("isDeleted"),
            "parameter_key_id": obj.get("parameterKeyId"),
            "id": obj.get("id"),
            "value": obj.get("value"),
            "name": obj.get("name")
        })
        return _obj


