# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr
from testit_api_client.models.link_type import LinkType

class Link(BaseModel):
    """
    Link
    """
    id: Optional[StrictStr] = Field(default=None, description="Link unique identifier")
    title: Optional[StrictStr] = Field(default=None, description="Link name.")
    url: constr(strict=True, min_length=1) = Field(default=..., description="Address can be specified without protocol, but necessarily with the domain.")
    description: Optional[StrictStr] = Field(default=None, description="Link description.")
    type: Optional[LinkType] = Field(default=None, description="Specifies the type of the link.")
    has_info: StrictBool = Field(default=..., alias="hasInfo", description="Flag defines if link relates to integrated jira service")
    __properties = ["id", "title", "url", "description", "type", "hasInfo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Link:
        """Create an instance of Link from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if title (nullable) is None
        # and __fields_set__ contains the field
        if self.title is None and "title" in self.__fields_set__:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Link:
        """Create an instance of Link from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Link.parse_obj(obj)

        _obj = Link.parse_obj({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "has_info": obj.get("hasInfo")
        })
        return _obj


