# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.attachment_model import AttachmentModel
from testit_api_client.models.link_model import LinkModel

class LastTestResultModel(BaseModel):
    """
    LastTestResultModel
    """
    id: StrictStr = Field(...)
    test_run_id: StrictStr = Field(default=..., alias="testRunId")
    auto_test_id: Optional[StrictStr] = Field(default=None, alias="autoTestId")
    comment: Optional[StrictStr] = None
    links: Optional[conlist(LinkModel)] = None
    work_item_version_id: StrictStr = Field(default=..., alias="workItemVersionId")
    attachments: Optional[conlist(AttachmentModel)] = None
    __properties = ["id", "testRunId", "autoTestId", "comment", "links", "workItemVersionId", "attachments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LastTestResultModel:
        """Create an instance of LastTestResultModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if auto_test_id (nullable) is None
        # and __fields_set__ contains the field
        if self.auto_test_id is None and "auto_test_id" in self.__fields_set__:
            _dict['autoTestId'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LastTestResultModel:
        """Create an instance of LastTestResultModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LastTestResultModel.parse_obj(obj)

        _obj = LastTestResultModel.parse_obj({
            "id": obj.get("id"),
            "test_run_id": obj.get("testRunId"),
            "auto_test_id": obj.get("autoTestId"),
            "comment": obj.get("comment"),
            "links": [LinkModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "work_item_version_id": obj.get("workItemVersionId"),
            "attachments": [AttachmentModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None
        })
        return _obj


