# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from testit_api_client.models.work_item_search_query_model import WorkItemSearchQueryModel

class FilterModel(BaseModel):
    """
    FilterModel
    """
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    data: Optional[WorkItemSearchQueryModel] = None
    project_id: StrictStr = Field(default=..., alias="projectId")
    fields_to_show: Optional[Any] = Field(default=None, alias="fieldsToShow")
    name: StrictStr = Field(...)
    id: StrictStr = Field(default=..., description="Unique ID of the entity")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Indicates if the entity is deleted")
    __properties = ["createdDate", "modifiedDate", "createdById", "modifiedById", "data", "projectId", "fieldsToShow", "name", "id", "isDeleted"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FilterModel:
        """Create an instance of FilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if data (nullable) is None
        # and __fields_set__ contains the field
        if self.data is None and "data" in self.__fields_set__:
            _dict['data'] = None

        # set to None if fields_to_show (nullable) is None
        # and __fields_set__ contains the field
        if self.fields_to_show is None and "fields_to_show" in self.__fields_set__:
            _dict['fieldsToShow'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FilterModel:
        """Create an instance of FilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FilterModel.parse_obj(obj)

        _obj = FilterModel.parse_obj({
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "data": WorkItemSearchQueryModel.from_dict(obj.get("data")) if obj.get("data") is not None else None,
            "project_id": obj.get("projectId"),
            "fields_to_show": obj.get("fieldsToShow"),
            "name": obj.get("name"),
            "id": obj.get("id"),
            "is_deleted": obj.get("isDeleted")
        })
        return _obj


