# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from testit_api_client.models.failure_category_model import FailureCategoryModel
from testit_api_client.models.failure_class_regex_model import FailureClassRegexModel

class FailureClassModel(BaseModel):
    """
    FailureClassModel
    """
    name: Optional[StrictStr] = None
    failure_category: FailureCategoryModel = Field(default=..., alias="failureCategory")
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    failure_class_regexes: Optional[conlist(FailureClassRegexModel)] = Field(default=None, alias="failureClassRegexes")
    id: StrictStr = Field(default=..., description="Unique ID of the entity")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Indicates if the entity is deleted")
    __properties = ["name", "failureCategory", "createdDate", "modifiedDate", "createdById", "modifiedById", "failureClassRegexes", "id", "isDeleted"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FailureClassModel:
        """Create an instance of FailureClassModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in failure_class_regexes (list)
        _items = []
        if self.failure_class_regexes:
            for _item in self.failure_class_regexes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['failureClassRegexes'] = _items
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if failure_class_regexes (nullable) is None
        # and __fields_set__ contains the field
        if self.failure_class_regexes is None and "failure_class_regexes" in self.__fields_set__:
            _dict['failureClassRegexes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FailureClassModel:
        """Create an instance of FailureClassModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FailureClassModel.parse_obj(obj)

        _obj = FailureClassModel.parse_obj({
            "name": obj.get("name"),
            "failure_category": obj.get("failureCategory"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "failure_class_regexes": [FailureClassRegexModel.from_dict(_item) for _item in obj.get("failureClassRegexes")] if obj.get("failureClassRegexes") is not None else None,
            "id": obj.get("id"),
            "is_deleted": obj.get("isDeleted")
        })
        return _obj


