# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from testit_api_client.models.custom_attribute_types_enum import CustomAttributeTypesEnum

class CustomAttributeSearchQueryModel(BaseModel):
    """
    CustomAttributeSearchQueryModel
    """
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Name of attribute")
    project_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="projectIds", description="Unique IDs of projects where attribute is in use")
    custom_attribute_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="customAttributeIds", description="Unique IDs of attributes for search restriction")
    custom_attribute_types: Optional[conlist(CustomAttributeTypesEnum, unique_items=True)] = Field(default=None, alias="customAttributeTypes", description="Collection of attribute types")
    is_global: Optional[StrictBool] = Field(default=None, alias="isGlobal", description="Indicates whether the attribute is available across all projects")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted", description="Indicates whether the attribute is deleted")
    __properties = ["name", "projectIds", "customAttributeIds", "customAttributeTypes", "isGlobal", "isDeleted"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomAttributeSearchQueryModel:
        """Create an instance of CustomAttributeSearchQueryModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if project_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.project_ids is None and "project_ids" in self.__fields_set__:
            _dict['projectIds'] = None

        # set to None if custom_attribute_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.custom_attribute_ids is None and "custom_attribute_ids" in self.__fields_set__:
            _dict['customAttributeIds'] = None

        # set to None if custom_attribute_types (nullable) is None
        # and __fields_set__ contains the field
        if self.custom_attribute_types is None and "custom_attribute_types" in self.__fields_set__:
            _dict['customAttributeTypes'] = None

        # set to None if is_global (nullable) is None
        # and __fields_set__ contains the field
        if self.is_global is None and "is_global" in self.__fields_set__:
            _dict['isGlobal'] = None

        # set to None if is_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.is_deleted is None and "is_deleted" in self.__fields_set__:
            _dict['isDeleted'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomAttributeSearchQueryModel:
        """Create an instance of CustomAttributeSearchQueryModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CustomAttributeSearchQueryModel.parse_obj(obj)

        _obj = CustomAttributeSearchQueryModel.parse_obj({
            "name": obj.get("name"),
            "project_ids": obj.get("projectIds"),
            "custom_attribute_ids": obj.get("customAttributeIds"),
            "custom_attribute_types": obj.get("customAttributeTypes"),
            "is_global": obj.get("isGlobal"),
            "is_deleted": obj.get("isDeleted")
        })
        return _obj


