# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, conlist, constr
from testit_api_client.models.custom_attribute_option_post_model import CustomAttributeOptionPostModel
from testit_api_client.models.custom_attribute_types_enum import CustomAttributeTypesEnum

class CustomAttributePostModel(BaseModel):
    """
    CustomAttributePostModel
    """
    options: Optional[conlist(CustomAttributeOptionPostModel)] = Field(default=None, description="Collection of attribute options     Available for attributes of type `options` and `multiple options` only")
    type: CustomAttributeTypesEnum = Field(default=..., description="Type of attribute")
    name: constr(strict=True, max_length=255, min_length=0) = Field(default=..., description="Name of the attribute")
    is_enabled: StrictBool = Field(default=..., alias="isEnabled", description="Indicates if the attribute is enabled")
    is_required: StrictBool = Field(default=..., alias="isRequired", description="Indicates if the attribute value is mandatory to specify")
    is_global: StrictBool = Field(default=..., alias="isGlobal", description="Indicates if the attribute is available across all projects")
    __properties = ["options", "type", "name", "isEnabled", "isRequired", "isGlobal"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomAttributePostModel:
        """Create an instance of CustomAttributePostModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item in self.options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['options'] = _items
        # set to None if options (nullable) is None
        # and __fields_set__ contains the field
        if self.options is None and "options" in self.__fields_set__:
            _dict['options'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomAttributePostModel:
        """Create an instance of CustomAttributePostModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CustomAttributePostModel.parse_obj(obj)

        _obj = CustomAttributePostModel.parse_obj({
            "options": [CustomAttributeOptionPostModel.from_dict(_item) for _item in obj.get("options")] if obj.get("options") is not None else None,
            "type": obj.get("type"),
            "name": obj.get("name"),
            "is_enabled": obj.get("isEnabled"),
            "is_required": obj.get("isRequired"),
            "is_global": obj.get("isGlobal")
        })
        return _obj


