# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from testit_api_client.models.assign_attachment_api_model import AssignAttachmentApiModel
from testit_api_client.models.create_link_api_model import CreateLinkApiModel
from testit_api_client.models.test_point_selector import TestPointSelector

class CreateTestRunAndFillByConfigurationsApiModel(BaseModel):
    """
    CreateTestRunAndFillByConfigurationsApiModel
    """
    project_id: StrictStr = Field(default=..., alias="projectId", description="Specifies the GUID of the project, in which a test run will be created.")
    test_plan_id: StrictStr = Field(default=..., alias="testPlanId", description="Specifies the GUID of the test plan, within which the test run will be created.")
    name: Optional[StrictStr] = Field(default=None, description="Specifies the name of the test run.")
    description: Optional[StrictStr] = Field(default=None, description="Specifies the test run description.")
    launch_source: Optional[StrictStr] = Field(default=None, alias="launchSource", description="Specifies the test run launch source.")
    attachments: Optional[conlist(AssignAttachmentApiModel)] = Field(default=None, description="Collection of attachment ids to relate to the test run")
    links: Optional[conlist(CreateLinkApiModel)] = Field(default=None, description="Collection of links to relate to the test run")
    test_point_selectors: conlist(TestPointSelector) = Field(default=..., alias="testPointSelectors", description="Specifies an array of work items and configuration to create a test run for.")
    __properties = ["projectId", "testPlanId", "name", "description", "launchSource", "attachments", "links", "testPointSelectors"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateTestRunAndFillByConfigurationsApiModel:
        """Create an instance of CreateTestRunAndFillByConfigurationsApiModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in test_point_selectors (list)
        _items = []
        if self.test_point_selectors:
            for _item in self.test_point_selectors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['testPointSelectors'] = _items
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if launch_source (nullable) is None
        # and __fields_set__ contains the field
        if self.launch_source is None and "launch_source" in self.__fields_set__:
            _dict['launchSource'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateTestRunAndFillByConfigurationsApiModel:
        """Create an instance of CreateTestRunAndFillByConfigurationsApiModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateTestRunAndFillByConfigurationsApiModel.parse_obj(obj)

        _obj = CreateTestRunAndFillByConfigurationsApiModel.parse_obj({
            "project_id": obj.get("projectId"),
            "test_plan_id": obj.get("testPlanId"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "launch_source": obj.get("launchSource"),
            "attachments": [AssignAttachmentApiModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "links": [CreateLinkApiModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "test_point_selectors": [TestPointSelector.from_dict(_item) for _item in obj.get("testPointSelectors")] if obj.get("testPointSelectors") is not None else None
        })
        return _obj


