# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr

class ConfigurationFilterModel(BaseModel):
    """
    ConfigurationFilterModel
    """
    project_ids: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="projectIds", description="Collection of identifiers of projects from which configurations will be taken")
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(default=None, description="Filter to search by name (case-insensitive, partial match)")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted", description="Is configurations deleted or existing")
    global_ids: Optional[conlist(StrictInt, unique_items=True)] = Field(default=None, alias="globalIds", description="Collection of global (integer) identifiers to filter configurations")
    __properties = ["projectIds", "name", "isDeleted", "globalIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConfigurationFilterModel:
        """Create an instance of ConfigurationFilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if project_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.project_ids is None and "project_ids" in self.__fields_set__:
            _dict['projectIds'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if is_deleted (nullable) is None
        # and __fields_set__ contains the field
        if self.is_deleted is None and "is_deleted" in self.__fields_set__:
            _dict['isDeleted'] = None

        # set to None if global_ids (nullable) is None
        # and __fields_set__ contains the field
        if self.global_ids is None and "global_ids" in self.__fields_set__:
            _dict['globalIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConfigurationFilterModel:
        """Create an instance of ConfigurationFilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConfigurationFilterModel.parse_obj(obj)

        _obj = ConfigurationFilterModel.parse_obj({
            "project_ids": obj.get("projectIds"),
            "name": obj.get("name"),
            "is_deleted": obj.get("isDeleted"),
            "global_ids": obj.get("globalIds")
        })
        return _obj


